% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation_recipe.cor_test.R,
%   R/visualisation_recipe.easycormatrix.R,
%   R/visualisation_recipe.easycorrelation.R
\name{visualisation_recipe.easycor_test}
\alias{visualisation_recipe.easycor_test}
\alias{visualisation_recipe.easycormatrix}
\alias{visualisation_recipe.easycorrelation}
\title{Visualisation Recipe for 'correlation' Objects}
\usage{
\method{visualisation_recipe}{easycor_test}(
  x,
  show_data = "point",
  show_text = "subtitle",
  smooth = NULL,
  point = NULL,
  text = NULL,
  labs = NULL,
  ...
)

\method{visualisation_recipe}{easycormatrix}(
  x,
  show_data = "tile",
  show_text = "text",
  show_legend = TRUE,
  tile = NULL,
  point = NULL,
  text = NULL,
  scale = NULL,
  scale_fill = NULL,
  labs = NULL,
  type = show_data,
  ...
)

\method{visualisation_recipe}{easycorrelation}(x, ...)
}
\arguments{
\item{x}{A correlation object.}

\item{show_data}{Show data. For correlation matrices, can be \code{"tile"}
(default) or \code{"point"}.}

\item{show_text}{Show labels with matrix values.}

\item{...}{Other arguments passed to other functions.}

\item{show_legend}{Show legend. Can be set to \code{FALSE} to remove the legend.}

\item{tile, point, text, scale, scale_fill, smooth, labs}{Additional aesthetics and
parameters for the geoms (see customization example).}

\item{type}{Alias for \code{show_data}, for backwards compatibility.}
}
\description{
Objects from the \code{correlation} package can be easily visualized. You can
simply run \code{plot()} on them, which will internally call the \code{visualisation_recipe()}
method to produce a basic \code{ggplot}. You can customize this plot ad-hoc or via
the arguments described below. See examples \href{https://easystats.github.io/correlation/reference/visualisation_recipe.easycormatrix.html#ref-examples}{\strong{here}}.
}
\examples{
\donttest{
# ==============================================
# Correlation Test
# ==============================================
if (require("see")) {
  rez <- cor_test(mtcars, "mpg", "wt")

  layers <- visualisation_recipe(rez, labs = list(x = "Miles per Gallon (mpg)"))
  layers
  plot(layers)

  plot(rez,
    show_text = "label",
    point = list(color = "#f44336"),
    text = list(fontface = "bold"),
    show_statistic = FALSE, show_ci = FALSE, stars = TRUE
  )
}
}
# ==============================================
# Correlation Matrix
# ==============================================
if (require("see")) {
  rez <- correlation(mtcars)

  x <- cor_sort(as.matrix(rez))
  layers <- visualisation_recipe(x)
  layers
  plot(layers)

  #' Get more details using `summary()`
  x <- summary(rez, redundant = TRUE, digits = 3)
  plot(visualisation_recipe(x))

  # Customize
  x <- summary(rez)
  layers <- visualisation_recipe(x,
    show_data = "points",
    scale = list(range = c(10, 20)),
    scale_fill = list(
      high = "#FF5722",
      low = "#673AB7",
      name = "r"
    ),
    text = list(color = "white"),
    labs = list(title = "My Plot")
  )
  plot(layers) + theme_modern()
}
\donttest{
# ==============================================
# Correlation Results (easycorrelation)
# ==============================================
if (require("see") && require("tidygraph") && require("ggraph")) {
  rez <- correlation(iris)

  layers <- visualisation_recipe(rez)
  layers
  plot(layers)
}
}
}
