% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcor.R
\name{simcor}
\alias{simcor}
\title{Simulate two correlated variables.}
\usage{
simcor(obs = 100, rhos = c(-0.5, 0.5))
}
\arguments{
\item{obs}{A single integer that determines the number of simulated observations in each of the pair of variables.}

\item{rhos}{A vector with at least one value that shows the theoretical correlation between the simulated pair of variables.}
}
\value{
a list with as many data.frames (each consisting of two columns) as there are values passed to the function argument 'rhos'.
}
\description{
Simulate pairs of variables with a predefined correlation between them.
}
\examples{
# Simulate a list with two data.frames. The first one contains variables that are correlated
# around -.8, the second one around .7. Both data.frames contain 200 observations.
simcor(obs = 200, rhos = c(-.8, .7))
}
\references{
\href{https://stirlingcodingclub.github.io/simulating_data/index.pdf}{pdf, see headline: Simulating data with known correlations}
}
\author{
Marcel Miché
}
