% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{anova.corregp}
\alias{anova.corregp}
\title{Building an ANOVA Table for Correspondence Regression}
\usage{
\method{anova}{corregp}(object, nf = NULL, cl = 0.95, nq = TRUE, ...)
}
\arguments{
\item{object}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{nf}{The number of dimensions to be retained in the reduced space. Defaults to all dimensions (no reduction).}

\item{cl}{The confidence level for the confidence intervals. Defaults to \code{0.95}.}

\item{nq}{Logical specifying whether to use a normal quantile (i.e. apply \code{\link[stats]{qnorm}}) in the computation of the confidence interval.
Defaults to \code{TRUE}. If \code{FALSE}, then the confidence interval is computed directly with the \code{\link[stats]{quantile}} function.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A matrix with the Chi-squared deviations for all the terms in the \code{formula} of \code{object}, based on the selected number of dimensions. If
  \code{object} was made with the argument \code{xep = FALSE}, then the output contains the Chi-squared deviation for every individual level in X.
}
\description{
Method to construct an ANOVA table for correspondence regression, i.e. a table with the Chi-squared deviation for each term in the \code{formula} of the
  \code{\link{corregp}} call (or of each individual level in X in case \code{xep = FALSE}).
}
\details{
If \code{object} was made with bootstrap replications, then \code{anova.corregp} will automatically compute confidence intervals for the Chi-squared
  deviations by means of the \code{\link{ci}} function.
}
\examples{
\dontrun{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
anova(haireye.crg, nf = 2)
}
}
\seealso{
\code{\link{print.anova.corregp}}, \code{\link{ci}}, \code{\link{summary.corregp}}.
}
