% Generated by roxygen2 (4.0.2): do not edit by hand
\name{screeplot.corregp}
\alias{screeplot.corregp}
\title{Scree Plotting}
\usage{
\method{screeplot}{corregp}(x, type = "value", add_ci = FALSE, cl = 0.95,
  nq = TRUE, ...)
}
\arguments{
\item{x}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{type}{A character specification  of which type of values to plot: either \code{"value"} for the \emph{actual eigenvalues}, \code{"\%"} for \emph{percentages} or
\code{"cum_\%"} for \emph{cumulative percentages}. Defaults to \code{"value"}.}

\item{add_ci}{Logical specifying whether to include the confidence intervals. Defaults to \code{FALSE}.}

\item{cl}{The confidence level for the confidence intervals. Defaults to \code{0.95}.}

\item{nq}{Logical specifying whether to use a normal quantile (i.e. apply \code{\link[stats]{qnorm}}) in the computation of the confidence intervals.
Defaults to \code{TRUE}. If \code{FALSE}, then the confidence intervals are computed directly with the \code{\link[stats]{quantile}} function.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A plot window containing the scree plot.
}
\description{
Method to produce a \emph{scree plot}, i.e. a bar chart of the eigenvalues.
}
\details{
\code{screeplot} (of a \code{corregp} output) makes use of \code{\link[gplots]{barplot2}} from the package \pkg{gplots}.
}
\examples{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
screeplot(haireye.crg, add_ci = TRUE)
}
\seealso{
\code{\link{corregp}}, \code{\link{summary.corregp}}.
}

