% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_prob_functions.R
\name{pvals_pp}
\alias{pvals_pp}
\title{Find PPs for SNPs and null model from P-values and MAFs}
\usage{
pvals_pp(pvals, f, type, N, s, W = 0.2, p1 = 1e-04)
}
\arguments{
\item{pvals}{P-values of SNPs}

\item{f}{Minor allele frequencies}

\item{type}{Type of experiment ('quant' or 'cc')}

\item{N}{Total sample size}

\item{s}{Proportion of cases (N1/N0+N1), ignored if type=='quant'}

\item{W}{Prior for the standard deviation of the effect size parameter, beta (default 0.2)}

\item{p1}{Prior probability a SNP is associated with the trait (default 1e-4)}
}
\value{
Posterior probabilities of null model (no genetic effect) and causality for each SNP
}
\description{
Posterior probabilities of causality from P-values
}
\details{
This function converts p-values to posterior probabilities of causality, including the null model of no genetic effect
}
\examples{

set.seed(1)
nsnps = 100
N0 = 5000
N1 = 5000
z_scores <- rnorm(nsnps, 0, 3)
p_values <- 2 * pnorm( - abs ( z_scores ) )

## generate example LD matrix and MAFs
library(mvtnorm)
nsamples = 1000

simx <- function(nsnps, nsamples, S, maf=0.1) {
    mu <- rep(0,nsnps)
    rawvars <- rmvnorm(n=nsamples, mean=mu, sigma=S)
    pvars <- pnorm(rawvars)
    x <- qbinom(1-pvars, 1, maf)
}

S <- (1 - (abs(outer(1:nsnps,1:nsnps,`-`))/nsnps))^4
X <- simx(nsnps,nsamples,S)
maf <- colMeans(X)

res <- pvals_pp(pvals = p_values, f = maf, type = "cc", N = N0+N1, s = N1/(N0+N1))
sum(res)
res


}
\author{
Anna Hutchinson
}
