% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semnet.r
\name{tCorpus$semnet}
\alias{tCorpus$semnet}
\alias{semnet}
\title{Create a semantic network based on the co-occurence of tokens in documents}
\arguments{
\item{feature}{The name of the feature column}

\item{measure}{The similarity measure. Currently supports: "con_prob" (conditional probability), "con_prob_weighted", "cosine" similarity, "count_directed" (i.e number of cooccurrences) and "count_undirected" (same as count_directed, but returned as an undirected network, chi2 (chi-square score))}

\item{context_level}{Determine whether features need to co-occurr within "documents" or "sentences"}

\item{backbone}{If True, add an edge attribute for the backbone alpha}

\item{n.batches}{If a number, perform the calculation in batches}
}
\description{
This function calculates the co-occurence of features and returns a network/graph in the igraph format, where nodes are tokens and edges represent the similarity/adjacency of tokens. Co-occurence is calcuated based on how often two tokens occured within the same document (e.g., news article, chapter, paragraph, sentence). The semnet_window() function can be used to calculate co-occurrence of tokens within a given token distance.
}
\section{Usage}{

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{
semnet(feature, measure = c('con_prob', 'con_prob_weighted', 'cosine', 'count_directed', 'count_undirected', 'chi2'),
       context_level = c('document','sentence'), backbone=F, n.batches=NA)
}
}

\examples{
text = c('A B C', 'D E F. G H I', 'A D', 'GGG')
tc = create_tcorpus(text, doc_id = c('a','b','c','d'), split_sentences = TRUE)

g = tc$semnet('token')
g
igraph::get.data.frame(g)
\dontrun{plot_semnet(g)}
}
