/* This file is automatically generated. DO NOT EDIT!
   Instead, edit gen-charwidth.py and re-run.  */

/*
 * Unicode East_Asian_Width property values.
 *
 * Defined in UAX #11 "East Asian Width"
 *
 *     http://www.unicode.org/reports/tr11/
 *
 * We use the two-stage lookup strategy described at
 *
 *     http://www.strchr.com/multi-stage_tables
 *
 */

#ifndef CHARWIDTH_H
#define CHARWIDTH_H

#include <stdint.h>

enum charwidth_prop {
	CHARWIDTH_OTHER = -3,
	CHARWIDTH_EMOJI = -2,
	CHARWIDTH_AMBIGUOUS = -1,
	CHARWIDTH_IGNORABLE = 0,
	CHARWIDTH_NONE = 1,
	CHARWIDTH_NARROW = 2,
	CHARWIDTH_WIDE = 3
};

static const uint8_t charwidth_stage1[] = {
/* U+0000 */  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
/* U+0800 */ 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
/* U+1000 */ 32, 33, 34, 35, 36, 37, 38, 39, 35, 35, 35, 35, 35, 40, 41, 42,
/* U+1800 */ 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 35, 53, 35, 35, 54, 55,
/* U+2000 */ 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
/* U+2800 */ 35, 35, 35, 35, 35, 35, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
/* U+3000 */ 82, 83, 84, 85, 86, 87, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+3800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+4000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+4800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 88, 80, 80, 80, 80,
/* U+5000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+5800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+6000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+6800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+7000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+7800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+8000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+8800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+9000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+9800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 89,
/* U+A000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 90, 35, 35, 91, 92, 35, 93,
/* U+A800 */ 94, 95, 96, 97, 98, 99,100,101, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+B000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+B800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+C000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+C800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+D000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,102,
/* U+D800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F800 */103,103, 80, 80,104,105,106,107, 35, 35,108,109,110,111,112,113,
/* U+10000 */114,115,116,117,103,118,119,120, 35,121,122,103, 35, 35,123,103,
/* U+10800 */124,125,126,127,128,129,130,131,132,133,103,103,134,103,103,103,
/* U+11000 */135,136,137,138,139,140,141,103,142,143,103,144,145,146,147,103,
/* U+11800 */103,148,103,103,149,150,103,103,151,152,153,103,103,103,103,103,
/* U+12000 */ 35, 35, 35, 35, 35, 35, 35,154,155, 35,156,103,103,103,103,103,
/* U+12800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+13000 */ 35, 35, 35, 35, 35, 35, 35, 35,157,103,103,103,103,103,103,103,
/* U+13800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+14000 */103,103,103,103,103,103,103,103, 35, 35, 35, 35,158,103,103,103,
/* U+14800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+15000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+15800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+16000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+16800 */ 35, 35, 35, 35,159,160,161,162,103,103,103,103,103,103,163,164,
/* U+17000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+17800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+18000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,165,
/* U+18800 */ 80, 80, 80, 80, 80,166,103,103,103,103,103,103,103,103,103,103,
/* U+19000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+19800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+1A000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+1A800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+1B000 */ 80, 80,167, 80, 80,168,103,103,103,103,103,103,103,103,103,103,
/* U+1B800 */103,103,103,103,103,103,103,103,169,170,103,103,103,103,103,103,
/* U+1C000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+1C800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+1D000 */ 35,171,172,173,174,103,175,103,176,177,178, 35, 35,179, 35,180,
/* U+1D800 */ 35, 35, 35, 35,181,182,103,103,103,103,103,103,103,103,103,103,
/* U+1E000 */183,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+1E800 */ 35,184,185,103,103,103,103,103,103,103,103,103,186,187,103,103,
/* U+1F000 */188,189,190,191,192,103,193,194,195,196,197,198,199,200,201,202,
/* U+1F800 */203,204,205,206,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+20000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+20800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+21000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+21800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+22000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+22800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+23000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+23800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+24000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+24800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+25000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+25800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+26000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+26800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+27000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+27800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+28000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+28800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+29000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+29800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+2A000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,207, 80, 80,
/* U+2A800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+2B000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,208, 80,
/* U+2B800 */209, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+2C000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+2C800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,210, 80, 80,
/* U+2D000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+2D800 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+2E000 */ 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
/* U+2E800 */ 80, 80, 80, 80, 80, 80, 80,211,103,103,103,103,103,103,103,103,
/* U+2F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+2F800 */ 80, 80, 80, 80,212,103,103,103,103,103,103,103,103,103,103,103,
/* U+30000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+30800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+31000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+31800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+32000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+32800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+33000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+33800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+34000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+34800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+35000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+35800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+36000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+36800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+37000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+37800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+38000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+38800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+39000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+39800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3A000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3A800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3B000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3B800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3C000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3C800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3D000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3D800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3E000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3E800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+3F800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+40000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+40800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+41000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+41800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+42000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+42800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+43000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+43800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+44000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+44800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+45000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+45800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+46000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+46800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+47000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+47800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+48000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+48800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+49000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+49800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4A000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4A800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4B000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4B800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4C000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4C800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4D000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4D800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4E000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4E800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+4F800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+50000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+50800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+51000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+51800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+52000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+52800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+53000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+53800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+54000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+54800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+55000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+55800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+56000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+56800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+57000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+57800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+58000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+58800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+59000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+59800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5A000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5A800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5B000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5B800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5C000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5C800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5D000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5D800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5E000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5E800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+5F800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+60000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+60800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+61000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+61800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+62000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+62800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+63000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+63800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+64000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+64800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+65000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+65800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+66000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+66800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+67000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+67800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+68000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+68800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+69000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+69800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6A000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6A800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6B000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6B800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6C000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6C800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6D000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6D800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6E000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6E800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+6F800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+70000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+70800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+71000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+71800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+72000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+72800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+73000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+73800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+74000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+74800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+75000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+75800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+76000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+76800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+77000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+77800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+78000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+78800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+79000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+79800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7A000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7A800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7B000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7B800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7C000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7C800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7D000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7D800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7E000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7E800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+7F800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+80000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+80800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+81000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+81800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+82000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+82800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+83000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+83800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+84000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+84800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+85000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+85800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+86000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+86800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+87000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+87800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+88000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+88800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+89000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+89800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8A000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8A800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8B000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8B800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8C000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8C800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8D000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8D800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8E000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8E800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+8F800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+90000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+90800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+91000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+91800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+92000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+92800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+93000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+93800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+94000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+94800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+95000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+95800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+96000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+96800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+97000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+97800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+98000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+98800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+99000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+99800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9A000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9A800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9B000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9B800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9C000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9C800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9D000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9D800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9E000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9E800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+9F800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A0000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A0800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A1000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A1800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A2000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A2800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A3000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A3800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A4000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A4800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A5000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A5800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A6000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A6800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A7000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A7800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A8000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A8800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A9000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+A9800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AA000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AA800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AB000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AB800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AC000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AC800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AD000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AD800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AE000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AE800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AF000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+AF800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B0000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B0800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B1000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B1800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B2000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B2800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B3000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B3800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B4000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B4800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B5000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B5800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B6000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B6800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B7000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B7800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B8000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B8800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B9000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+B9800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BA000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BA800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BB000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BB800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BC000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BC800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BD000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BD800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BE000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BE800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BF000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+BF800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C0000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C0800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C1000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C1800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C2000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C2800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C3000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C3800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C4000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C4800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C5000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C5800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C6000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C6800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C7000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C7800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C8000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C8800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C9000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+C9800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CA000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CA800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CB000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CB800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CC000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CC800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CD000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CD800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CE000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CE800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CF000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+CF800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D0000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D0800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D1000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D1800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D2000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D2800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D3000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D3800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D4000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D4800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D5000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D5800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D6000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D6800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D7000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D7800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D8000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D8800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D9000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+D9800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DA000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DA800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DB000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DB800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DC000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DC800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DD000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DD800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DE000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DE800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DF000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+DF800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E0000 */213,103,214,215,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E0800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E1000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E1800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E2000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E2800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E3000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E3800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E4000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E4800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E5000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E5800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E6000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E6800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E7000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E7800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E8000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E8800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E9000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+E9800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EA000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EA800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EB000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EB800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EC000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EC800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+ED000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+ED800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EE000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EE800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EF000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+EF800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F0000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F0800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F1000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F1800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F2000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F2800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F3000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F3800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F4000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F4800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F5000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F5800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F6000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F6800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F7000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F7800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F8000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F8800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F9000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+F9800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FA000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FA800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FB000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FB800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FC000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FC800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FD000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FD800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FE000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FE800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FF000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+FF800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+100000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+100800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+101000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+101800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+102000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+102800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+103000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+103800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+104000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+104800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+105000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+105800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+106000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+106800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+107000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+107800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+108000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+108800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+109000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+109800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10A000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10A800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10B000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10B800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10C000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10C800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10D000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10D800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10E000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10E800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10F000 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
/* U+10F800 */103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103
};

static const int8_t charwidth_stage2[][128] = {
  /* block 0 */
  { -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3
  },

  /* block 1 */
  { -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2, -1,  2,  2, -1,  2,  2, -1, -1,  2, -1,  2,  2,  0, -1,  2,
    -1, -1, -1, -1, -1,  2, -1, -1, -1, -1, -1,  2, -1, -1, -1, -1,
     2,  2,  2,  2,  2,  2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -1,  2,  2,  2,  2,  2,  2, -1, -1,  2,  2,  2,  2,  2, -1, -1,
    -1, -1,  2,  2,  2,  2, -1,  2, -1, -1, -1,  2, -1, -1,  2,  2,
    -1,  2, -1, -1,  2,  2,  2, -1, -1, -1, -1,  2, -1,  2, -1,  2
  },

  /* block 2 */
  {  2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2, -1,  2, -1,  2,  2,  2,  2,  2,  2,  2, -1,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -1, -1,  2,  2,  2, -1,  2,  2,  2,  2,
     2, -1, -1, -1,  2,  2,  2,  2, -1,  2,  2,  2,  2,  2,  2, -1,
    -1, -1, -1,  2, -1,  2,  2,  2, -1, -1, -1, -1,  2, -1,  2,  2,
     2,  2, -1, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -1, -1,  2,  2,  2, -1,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 3 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -1,  2,
    -1,  2, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2, -1,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 4 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 5 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -1,  2,  2, -1,  2, -1, -1, -1,  2, -1,  2,  2,
    -1,  2,  2,  2,  2,  2,  2,  2, -1, -1, -1, -1,  2, -1,  2, -1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 6 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2
  },

  /* block 7 */
  { -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2, -3,  2, -3,  2,  2,
     2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -3, -1, -1, -1, -1, -1, -1, -1,  2,  2,  2,  2,  2,  2,
     2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1,  2, -1, -1, -1, -1, -1, -1, -1,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 8 */
  {  2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 9 */
  {  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 10 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2,
    -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 11 */
  {  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2, -3, -3,  2,  2,  2,
    -3,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  1,
     2,  1,  1,  2,  1,  1,  2,  1, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 12 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  0, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 13 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  2,  2,  1,
     1,  1,  1,  1,  1,  2,  2,  1,  1,  2,  1,  1,  1,  1,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 14 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,
     2,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3, -3,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 15 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3
  },

  /* block 16 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  2,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  2,  1,  1,  1,  2,  1,  1,  1,  1,  1, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1, -3, -3,  2, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 17 */
  { -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 18 */
  {  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  2,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     2,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 19 */
  {  2,  1,  1,  1, -3,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  2,
     2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,
     2, -3,  2, -3, -3, -3,  2,  2,  2,  2, -3, -3,  1,  2,  1,  1,
     1,  1,  1,  1,  1, -3, -3,  1,  1, -3, -3,  1,  1,  1,  2, -3,
    -3, -3, -3, -3, -3, -3, -3,  1, -3, -3, -3, -3,  2,  2, -3,  2,
     2,  2,  1,  1, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3
  },

  /* block 20 */
  { -3,  1,  1,  1, -3,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,  2,
     2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,
     2, -3,  2,  2, -3,  2,  2, -3,  2,  2, -3, -3,  1, -3,  1,  1,
     1,  1,  1, -3, -3, -3, -3,  1,  1, -3, -3,  1,  1,  1, -3, -3,
    -3,  1, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2, -3,  2, -3,
    -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  2,  2,  2,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 21 */
  { -3,  1,  1,  1, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,
     2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,
     2, -3,  2,  2, -3,  2,  2,  2,  2,  2, -3, -3,  1,  2,  1,  1,
     1,  1,  1,  1,  1,  1, -3,  1,  1,  1, -3,  1,  1,  1, -3, -3,
     2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  1,  1, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2, -3, -3, -3, -3, -3, -3, -3,  2,  1,  1,  1,  1,  1,  1
  },

  /* block 22 */
  { -3,  1,  1,  1, -3,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  2,
     2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,
     2, -3,  2,  2, -3,  2,  2,  2,  2,  2, -3, -3,  1,  2,  1,  1,
     1,  1,  1,  1,  1, -3, -3,  1,  1, -3, -3,  1,  1,  1, -3, -3,
    -3, -3, -3, -3, -3, -3,  1,  1, -3, -3, -3, -3,  2,  2, -3,  2,
     2,  2,  1,  1, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 23 */
  { -3, -3,  1,  2, -3,  2,  2,  2,  2,  2,  2, -3, -3, -3,  2,  2,
     2, -3,  2,  2,  2,  2, -3, -3, -3,  2,  2, -3,  2, -3,  2,  2,
    -3, -3, -3,  2,  2, -3, -3, -3,  2,  2,  2, -3, -3, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,  1,  1,
     1,  1,  1, -3, -3, -3,  1,  1,  1, -3,  1,  1,  1,  1, -3, -3,
     2, -3, -3, -3, -3, -3, -3,  1, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3
  },

  /* block 24 */
  {  1,  1,  1,  1, -3,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,
     2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,  2,  1,  1,
     1,  1,  1,  1,  1, -3,  1,  1,  1, -3,  1,  1,  1,  1, -3, -3,
    -3, -3, -3, -3, -3,  1,  1, -3,  2,  2,  2, -3, -3, -3, -3, -3,
     2,  2,  1,  1, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 25 */
  {  2,  1,  1,  1, -3,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,
     2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3,  2,  2,  2,  2,  2, -3, -3,  1,  2,  1,  1,
     1,  1,  1,  1,  1, -3,  1,  1,  1, -3,  1,  1,  1,  1, -3, -3,
    -3, -3, -3, -3, -3,  1,  1, -3, -3, -3, -3, -3, -3, -3,  2, -3,
     2,  2,  1,  1, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 26 */
  {  1,  1,  1,  1, -3,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,
     2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  2,  1,  1,
     1,  1,  1,  1,  1, -3,  1,  1,  1, -3,  1,  1,  1,  1,  2,  2,
    -3, -3, -3, -3,  2,  2,  2,  1,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  1,  1, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 27 */
  { -3, -3,  1,  1, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3, -3,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2, -3, -3, -3,  1, -3, -3, -3, -3,  1,
     1,  1,  1,  1,  1, -3,  1, -3,  1,  1,  1,  1,  1,  1,  1,  1,
    -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3,  1,  1,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 28 */
  { -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  1,  2,  2,  1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3,  2,
     2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 29 */
  { -3,  2,  2, -3,  2, -3, -3,  2,  2, -3,  2, -3, -3,  2, -3, -3,
    -3, -3, -3, -3,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,
    -3,  2,  2,  2, -3,  2, -3,  2, -3, -3,  2,  2, -3,  2,  2,  2,
     2,  1,  2,  2,  1,  1,  1,  1,  1,  1, -3,  1,  1,  2, -3, -3,
     2,  2,  2,  2,  2, -3,  2, -3,  1,  1,  1,  1,  1,  1, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 30 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  1,  2,  1,  2,  1,  2,  2,  2,  2,  1,  1,
     2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,
    -3,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 31 */
  {  1,  1,  1,  1,  1,  2,  1,  1,  2,  2,  2,  2,  2,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, -3,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  1,  2,  2,  2,  2,  2,  2, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 32 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  2,  2,  2,  2,  1,  1,
     1,  2,  1,  1,  1,  2,  2,  1,  1,  1,  1,  1,  1,  1,  2,  2,
     2,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 33 */
  {  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3,  2, -3, -3, -3, -3, -3,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 34 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 35 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 36 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2, -3,  2, -3,  2,  2,  2,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 37 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2, -3,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2, -3,
     2, -3,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 38 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2, -3,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  1,  1,  1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3
  },

  /* block 39 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2, -3, -3
  },

  /* block 40 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 41 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,
     2,  2,  1,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  1,  1,  1,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,
     2, -3,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 42 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3
  },

  /* block 43 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 44 */
  {  2,  2,  2,  2,  2,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  2, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 45 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3,
     2, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,
     2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 46 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 47 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1, -3, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3, -3,  1
  },

  /* block 48 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 49 */
  {  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3
  },

  /* block 50 */
  {  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2
  },

  /* block 51 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, -3, -3, -3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 52 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3,
     1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  1,  2,  2,
     2,  2,  1,  1,  1,  2,  2,  1,  1,  1, -3, -3, -3, -3, -3, -3
  },

  /* block 53 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3,  1,  1,  1,  1,  1
  },

  /* block 54 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2, -3,  2, -3,  2, -3,  2, -3,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3
  },

  /* block 55 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3
  },

  /* block 56 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,
    -1,  2,  2, -1, -1, -1, -1,  2, -1, -1,  2,  2, -1, -1,  2,  2,
    -1, -1, -1,  2, -1, -1, -1, -1, -3, -3,  0,  0,  0,  0,  0,  2,
    -1,  2, -1, -1,  2, -1,  2,  2,  2,  2,  2, -1,  2,  2, -1,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     0,  0,  0,  0,  0, -3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     2,  2, -3, -3, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -1
  },

  /* block 57 */
  {  2, -1, -1, -1, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -1,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 58 */
  {  2,  2,  2, -1,  2, -1,  2,  2,  2, -1,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -1,  2,  2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2, -1, -1,  2,  2,  2, -1,  2,  2,  2,  2, -1,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -1, -1,  2,  2,  2,  2,  2,  2, -1, -1, -1, -1,  2,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  2,  2,  2,  2,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  2,  2,  2,  2,  2,  2
  },

  /* block 59 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2, -1,  2,  2, -3, -3, -3, -3,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -1, -1,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2, -1,  2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -1,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 60 */
  { -1,  2, -1, -1,  2,  2,  2, -1, -1,  2,  2, -1,  2,  2,  2, -1,
     2, -1,  2,  2,  2, -1,  2,  2,  2,  2, -1,  2,  2, -1, -1, -1,
    -1,  2,  2, -1,  2, -1,  2, -1, -1, -1, -1, -1, -1,  2, -1,  2,
     2,  2,  2,  2, -1, -1, -1, -1,  2,  2,  2,  2, -1, -1,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -1,  2,  2,  2, -1,  2,  2,  2,
     2,  2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -1, -1,  2,  2, -1, -1, -1, -1,  2,  2, -1, -1,  2,  2, -1, -1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 61 */
  {  2,  2, -1, -1,  2,  2, -1, -1,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -1,  2,  2,  2, -1,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 62 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2, -1,  2,  2,  2,  2,  2,  2,  2, -2, -2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 63 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -2, -2, -2, -2,  2,  2,  2,
    -2,  2,  2, -2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 64 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
  },

  /* block 65 */
  { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  2, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
  },

  /* block 66 */
  { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  2,  2,  2,  2,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 67 */
  { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     2,  2, -1, -1, -1, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -1, -1,  2, -1, -1, -1, -1, -1, -1, -1,  2,  2,  2,  2,  2,  2,
     2,  2, -1, -1,  2,  2, -1, -1,  2,  2,  2,  2, -1, -1,  2,  2,
    -1, -1,  2,  2,  2,  2, -1, -1, -1,  2,  2, -1,  2,  2, -1, -1,
    -1, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2, -1, -1, -1, -1,  2,  2,  2,  2,  2,  2,  2,  2,  2, -1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -2, -2,  2
  },

  /* block 68 */
  {  2,  2,  2,  2,  2, -1, -1,  2,  2, -1,  2,  2,  2,  2, -1, -1,
     2,  2,  2,  2, -2, -2,  2,  2,  2,  2,  2,  2, -1,  2, -1,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -1,  2, -1,  2,  2,  2,  2,  2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -1, -1,  2, -1, -1, -1,  2, -1, -1, -1, -1,  2, -1, -1,  2, -1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -2
  },

  /* block 69 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -1, -1,
     2, -2,  2,  2,  2,  2,  2,  2,  2,  2, -2, -2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -2, -2, -1,
     2,  2,  2,  2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1,
    -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1,  2, -1,  2,  2,  2,  2, -1, -1, -2, -1, -1, -1, -1, -1,
    -1, -1, -2, -2, -1, -2, -1, -1, -1, -1, -2, -1, -1, -2, -1, -1
  },

  /* block 70 */
  {  2,  2,  2,  2,  2, -2,  2,  2,  2,  2, -2, -2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -1,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -2,  2, -2,  2,
     2,  2,  2, -2, -2, -2,  2, -2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
  },

  /* block 71 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -2, -2, -2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 72 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -2, -2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -2,  2,  2,  2,  2, -2, -1, -1, -1, -1,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 73 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 74 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 75 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,
     1,  1,  2,  2, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 76 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3,  2, -3, -3, -3, -3, -3,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3,  2,
     2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,  1
  },

  /* block 77 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2, -3,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 78 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 79 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 80 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 81 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3, -3
  },

  /* block 82 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  1,  1,  1,  1,  1,  1,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,
    -3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 83 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, -3, -3,  1,  1,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 84 */
  { -3, -3, -3, -3, -3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3,
    -3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 85 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 86 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3, -1, -1, -1, -1, -1, -1, -1, -1,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 87 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3
  },

  /* block 88 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 89 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 90 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 91 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,
     1,  1,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2
  },

  /* block 92 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 93 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 94 */
  {  2,  2,  1,  2,  2,  2,  1,  2,  2,  2,  2,  1,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  1,  1,  1,  1,  1,  2,  2,  2,  2, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 95 */
  {  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3
  },

  /* block 96 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,  2,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3
  },

  /* block 97 */
  {  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,  2,  2,
     2,  2,  2,  2,  2,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3
  },

  /* block 98 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  1,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  2,  2
  },

  /* block 99 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  2,  1,  1,  1,  2,  2,  1,  1,  2,  2,  2,  2,  2,  1,  1,
     2,  1,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,
     2,  2,  2,  2,  2,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 100 */
  { -3,  2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2, -3,
    -3,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 101 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  2,  1,  1, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3
  },

  /* block 102 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3
  },

  /* block 103 */
  { -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 104 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 105 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 106 */
  {  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3,  2,  1,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2, -3,  2, -3,
     2,  2, -3,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 107 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 108 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 109 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3
  },

  /* block 110 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3, -3,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, -3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, -3,  3,  3,  3,  3, -3, -3, -3, -3,
     2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 111 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  0
  },

  /* block 112 */
  { -3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 113 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
    -3, -3,  2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,
    -3, -3,  2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3, -3,  2,  2,  2,  2,  2,  2,  2, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2, -1, -3, -3
  },

  /* block 114 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2, -3,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 115 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3
  },

  /* block 116 */
  {  2,  2,  2, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 117 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
     2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1, -3, -3
  },

  /* block 118 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3
  },

  /* block 119 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1, -3, -3, -3, -3, -3
  },

  /* block 120 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 121 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3
  },

  /* block 122 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 123 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 124 */
  {  2,  2,  2,  2,  2,  2, -3, -3,  2, -3,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3,  2,  2, -3, -3, -3,  2, -3, -3,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 125 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
    -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -3,  2,  2, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2
  },

  /* block 126 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 127 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 128 */
  {  2,  1,  1,  1, -3,  1,  1, -3, -3, -3, -3, -3,  1,  1,  1,  1,
     2,  2,  2,  2, -3,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3, -3,  1,  1,  1, -3, -3, -3, -3,  1,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 129 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  1,  1, -3, -3, -3, -3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 130 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 131 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 132 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 133 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -3, -3, -3, -3, -3, -3, -3,  2,  2,  2,  2,  2,  2
  },

  /* block 134 */
  { -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3
  },

  /* block 135 */
  {  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2, -3, -3,
    -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,  1
  },

  /* block 136 */
  {  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,
     2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3
  },

  /* block 137 */
  {  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  1,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 138 */
  {  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  2, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 139 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  1, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 140 */
  {  2,  2,  2,  2,  2,  2,  2, -3,  2, -3,  2,  2,  2,  2, -3,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3
  },

  /* block 141 */
  {  1,  1,  1,  1, -3,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  2,
     2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,
     2, -3,  2,  2, -3,  2,  2,  2,  2,  2, -3, -3,  1,  2,  1,  1,
     1,  1,  1,  1,  1, -3, -3,  1,  1, -3, -3,  1,  1,  1, -3, -3,
     2, -3, -3, -3, -3, -3, -3,  1, -3, -3, -3, -3, -3,  2,  2,  2,
     2,  2,  1,  1, -3, -3,  1,  1,  1,  1,  1,  1,  1, -3, -3, -3,
     1,  1,  1,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 142 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2, -3,  2, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 143 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 144 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,
     1,  1,  1,  1,  1,  1, -3, -3,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 145 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 146 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 147 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 148 */
  { -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,  2
  },

  /* block 149 */
  {  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  2,  1,  1,  1,  1,  2,
     2,  2,  2,  2,  2,  2,  2,  1, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 150 */
  {  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2, -3,  2,  2,
     2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 151 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,
     1,  1,  1,  1,  1,  1,  1, -3,  1,  1,  1,  1,  1,  1,  1,  1,
     2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 152 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, -3,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 153 */
  {  2,  2,  2,  2,  2,  2,  2, -3,  2,  2, -3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  1,  1,  1,  1,  1,  1, -3, -3, -3,  1, -3,  1,  1, -3,  1,
     1,  1,  1,  1,  1,  1,  2,  1, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 154 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 155 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 156 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 157 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 158 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 159 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 160 */
  { -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,
     1,  1,  1,  1,  1,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 161 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,
     2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3,  2,  2,  2
  },

  /* block 162 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 163 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -3
  },

  /* block 164 */
  { -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,  1,
     1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 165 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 166 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 167 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 168 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3, -3
  },

  /* block 169 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3
  },

  /* block 170 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  2,  1,  1,  2,
     0,  0,  0,  0, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 171 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 172 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  2,  2,  2,  1,  1,  1,
     1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1
  },

  /* block 173 */
  {  1,  1,  1,  2,  2,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 174 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  1,  1,  1,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 175 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 176 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 177 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,
    -3, -3,  2, -3, -3,  2,  2, -3, -3,  2,  2,  2,  2, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2, -3,  2,  2,  2,
     2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 178 */
  {  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2, -3, -3,  2,  2,  2,
     2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2, -3,
     2,  2,  2,  2,  2, -3,  2, -3, -3, -3,  2,  2,  2,  2,  2,  2,
     2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 179 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 180 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 181 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,
     2,  2,  2,  2,  2,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 182 */
  {  2,  2,  2,  2,  1,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,  1,  1,  1,  1,  1,
    -3,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 183 */
  {  1,  1,  1,  1,  1,  1,  1, -3,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, -3, -3,  1,  1,  1,  1,  1,
     1,  1, -3,  1,  1, -3,  1,  1,  1,  1,  1, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 184 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -3, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 185 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,  2,  2,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 186 */
  {  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3,  2,  2, -3,  2, -3, -3,  2, -3,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2, -3,  2,  2,  2,  2, -3,  2, -3,  2, -3, -3, -3, -3,
    -3, -3,  2, -3, -3, -3, -3,  2, -3,  2, -3,  2, -3,  2,  2,  2,
    -3,  2,  2, -3,  2, -3, -3,  2, -3,  2, -3,  2, -3,  2, -3,  2,
    -3,  2,  2, -3,  2, -3, -3,  2,  2,  2,  2, -3,  2,  2,  2,  2,
     2,  2,  2, -3,  2,  2,  2,  2, -3,  2,  2,  2,  2, -3,  2, -3
  },

  /* block 187 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
    -3,  2,  2,  2, -3,  2,  2,  2,  2,  2, -3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 188 */
  {  2,  2,  2,  2, -2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 189 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3,
    -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -2,
    -3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 190 */
  { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  2,  2, -3, -3, -3,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  2, -3,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  2,  2, -3, -3, -3, -3,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
  },

  /* block 191 */
  { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1,
    -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2
  },

  /* block 192 */
  {  3, -2, -2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -2,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -2,
     3,  3, -2, -2, -2, -2, -2, -2, -2, -2, -2,  3, -3, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3,
    -2, -2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 193 */
  { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2,  2,  2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2
  },

  /* block 194 */
  { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2,  2,  2, -2, -2,  2, -2, -2, -2,  2,  2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2,  2,  2, -2, -2, -2,  2, -2, -2, -2, -2, -2, -2, -2, -2, -2
  },

  /* block 195 */
  { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2
  },

  /* block 196 */
  { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,  2, -2
  },

  /* block 197 */
  { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2, -2, -2, -2, -2, -2, -2,  2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2,  2,  2,  2,  2,  2,  2,  2, -2,
    -2,  2,  2, -2, -2, -2, -2, -2, -2, -2, -2,  2,  2,  2,  2,  2
  },

  /* block 198 */
  {  2,  2,  2,  2,  2,  2,  2, -2,  2,  2, -2, -2, -2, -2,  2,  2,
    -2,  2,  2,  2,  2, -2, -2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -2, -2,  2,  2, -2,  2,  2,  2,  2,  2,  2,  2,
     2, -2, -2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -2,  2,  2,  2,
     2,  2, -2, -2, -2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2, -2, -2, -2,  2,  2,  2,  2,  2,  2,  2,  2, -2, -2, -2,  2,
     2, -2,  2, -2,  2,  2,  2,  2, -2,  2,  2,  2,  2,  2,  2, -2,
     2,  2,  2, -2,  2,  2,  2,  2,  2,  2, -2, -2, -2, -2, -2, -2
  },

  /* block 199 */
  { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 200 */
  { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2,  2,  2,  2,  2,  2, -2, -2, -2, -2, -2,
    -2, -2, -2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -2, -2, -2, -2, -2, -2,  2,  2,  2, -2,  2, -2, -2, -3, -3, -3,
    -2,  2,  2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 201 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 202 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 203 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 204 */
  {  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3, -3, -3, -3, -3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 205 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, -3, -3, -3, -3,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,  3, -2, -2, -2, -3,
    -2, -2, -2, -2, -2, -2,  3, -2, -2, -2, -2, -2, -2, -3, -3, -3,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 206 */
  { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 207 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 208 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 209 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 210 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 211 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 212 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  },

  /* block 213 */
  { -3,  0, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 214 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 215 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3
  }
};

static int charwidth(uint32_t code)
{
	const uint32_t block_size = 128;
	uint8_t i = charwidth_stage1[code / block_size];
	return charwidth_stage2[i][code % block_size];
}

#endif /* CHARWIDTH_H */
