% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterator-collect.R
\name{collect}
\alias{collect}
\alias{loop}
\title{Iterate over iterator functions}
\usage{
collect(x, n = NULL)

loop(loop)
}
\arguments{
\item{x}{An iterator function.}

\item{n}{The number of elements to collect. If \code{x} is an infinite
sequence, \code{n} must be supplied to prevent an infinite loop.}

\item{loop}{A \code{for} loop expression.}
}
\value{
\code{collect()} returns a list of values; \code{loop()} returns
the \code{\link[=exhausted]{exhausted()}} sentinel, invisibly.
}
\description{
\code{loop()} and \code{collect()} are helpers for iterating over
\link[=iterator]{iterator functions} such as \link[=generator]{generators}.
\itemize{
\item \code{loop()} takes a \code{for} loop expression in which the collection
can be an iterator function.
\item \code{collect()} loops over the iterator and collects the values in a
list.
}
}
\examples{
generate_abc <- generator(function() for (x in letters[1:3]) yield(x))
abc <- generate_abc()

# Collect 1 element:
collect(abc, n = 1)

# Collect all remaining elements:
collect(abc)

# With exhausted iterators collect() returns an empty list:
collect(abc)


# With loop() you can use `for` loops with iterators:
abc <- generate_abc()
loop(for (x in abc) print(x))
}
\seealso{
\code{\link[=async_collect]{async_collect()}} for async generators.
}
