% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cops.R
\name{cops}
\alias{cops}
\title{High Level COPS Function}
\usage{
cops(
  dis,
  variant = c("1", "2", "Variant1", "Variant2", "v1", "v2", "COPS-C", "P-COPS",
    "configuration-c", "profile", "copstress-c", "p-copstress", "COPS-P", "copstress-p",
    "cops-c", "p-cops", "copsc", "pcops"),
  ...
)
}
\arguments{
\item{dis}{a dissimilarity matrix or a dist object}

\item{variant}{a character string specifying which variant of COPS to fit. Allowed is any of the following "1","2","Variant1","Variant2","v1","v2","COPS-C","P-COPS","configuration-c","profile","copstress-c","p-copstress". Defaults to "COPS-C".}

\item{...}{arguments to be passed to  \code{\link{copstressMin}} (for Variant 1) or \code{\link{pcops}} (for Variant 2).}
}
\value{
For COPS-C Variant 1 see \code{\link{copstressMin}}, for P-COPS Variant 2 see \code{\link{pcops}}
}
\description{
About the function cops: The high level function allows for minimizing copstress for a clustered MDS configuration. Allows to choose COPS-C (finding a configuration from copstress with cordillera penalty) and profile COPS (finding hyperparameters for MDS models with power transformations). It is a wrapper for copstressMin and pcops.
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)

#COPS-C with equal weight to stress and cordillera 
res1<-cops(dis,variant="COPS-C",stressweight=0.75,cordweight=0.25,
          minpts=2,itmax=1000) #use higher itmax in real
res1
summary(res1)
plot(res1)
plot(res1,"reachplot")


\donttest{
#s-stress type copstress (i.e. kappa=2, lambda=2)
res3<-cops(dis,variant="COPS-C",kappa=2,lambda=2,stressweight=0.5,cordweight=0.5) 
res3
summary(res3)
plot(res3)


# power-stress type profile copstress
# search for optimal kappa and lambda between
# kappa=0.5,lambda=0.5 and kappa=2,lambda=5
# nu is fixed on -1
ws<-1/dis
diag(ws)<-1 
res5<-cops(dis,variant="P-COPS",loss="powerstress",
          theta=c(1.4,3,-1), lower=c(1,0.5,-1),upper=c(3,5,-1),
          weightmat=ws, stressweight=0.9,cordweight=0.1) 
res5
summary(res5)
plot(res5)
}



}
\keyword{clustering}
\keyword{multivariate}
