% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadbin.R
\name{loadbin}
\alias{loadbin}
\title{Read binary data into array}
\usage{
loadbin(
  filename,
  dim,
  bytes = 4,
  type = "numeric",
  signed = FALSE,
  endian = "little"
)
}
\arguments{
\item{filename}{path of the file to be loaded}

\item{dim}{vector specifying the dimensions of the array}

\item{bytes}{number of bytes per number in the binary file}

\item{type}{character vector of length describing the data type: "numeric" (default), "double", "integer", "int", "logical", "complex", "character", "raw"}

\item{signed}{logical. Only used for integers of sizes 1 and 2, when it determines if the quantity on file should be regarded as a signed or unsigned integer.}

\item{endian}{endian-type ("big" or "little") of the file}
}
\value{
Returns an array of dimension dim.
}
\description{
Reads binary data using the base function \code{\link[base]{readBin}} and recasts it into an array of custom dimensions.
}
\author{
Danail Obreschkow
}
