% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convoSPAT_fitpred.R
\name{Aniso_fit}
\alias{Aniso_fit}
\title{Fit the stationary spatial model}
\usage{
Aniso_fit(geodata, coords = geodata$coords, data = geodata$data,
  cov.model = "exponential", mean.model = data ~ 1, local.pars.LB = NULL,
  local.pars.UB = NULL, local.ini.pars = NULL)
}
\arguments{
\item{geodata}{A list containing elements \code{coords} and \code{data} as
described next. Typically an object of the class "\code{geodata}", although
a geodata object only allows \code{data} to be a vector (no replicates).
If not provided, the arguments \code{coords} and \code{data} must be
provided instead.}

\item{coords}{An N x 2 matrix where each row has the two-dimensional
coordinates of the N data locations. By default, it takes the \code{coords}
component of the argument \code{geodata}, if provided.}

\item{data}{A vector or matrix with N rows, containing the data values.
Inputting a vector corresponds to a single replicate of data, while
inputting a matrix corresponds to replicates. In the case of replicates,
the model assumes the replicates are independent and identically
distributed.}

\item{cov.model}{A string specifying the model for the correlation
function; following \code{geoR}, defaults to \code{"exponential"}.
Options available in this package are: "\code{exponential}",
\code{"cauchy"}, \code{"matern"}, \code{"circular"}, \code{"cubic"},
\code{"gaussian"}, \code{"spherical"}, and \code{"wave"}. For further
details, see documentation for \code{\link[geoR]{cov.spatial}}.}

\item{mean.model}{An object of class \code{\link[stats]{formula}},
specifying the mean model to be used. Defaults to an intercept only.}

\item{local.pars.LB,local.pars.UB}{Optional vectors of lower and upper
bounds, respectively, used by the \code{"L-BFGS-B"} method option in the
\code{\link[stats]{optim}} function for the local parameter estimation.
Each vector must be of length five,
containing values for lam1, lam2, tausq, sigmasq, and nu. Default for
\code{local.pars.LB} is \code{rep(1e-05,5)}; default for
\code{local.pars.UB} is \code{c(max.distance/2, max.distance/2, 4*resid.var, 4*resid.var, 100)},
where \code{max.distance} is the maximum interpoint distance of the
observed data and \code{resid.var} is the residual variance from using
\code{\link[stats]{lm}} with \code{mean.model}.}

\item{local.ini.pars}{Optional vector of initial values used by the
\code{"L-BFGS-B"} method option in the \code{\link[stats]{optim}}
function for the local parameter estimation. The vector must be of length
five, containing values for lam1, lam2, tausq, sigmasq, and nu. Defaults
to \code{c(max.distance/10, max.distance/10, 0.1*resid.var, 0.9*resid.var, 1)},
where \code{max.distance} is the maximum interpoint distance of the
observed data and \code{resid.var} is the residual variance from using
\code{\link[stats]{lm}} with \code{mean.model}.}
}
\value{
A list with the following components:
\item{MLEs.save}{Table of local maximum likelihood estimates for each
mixture component location.}
\item{data}{Observed data values.}
\item{beta.GLS}{Vector of generalized least squares estimates of beta,
the mean coefficients.}
\item{beta.cov}{Covariance matrix of the generalized least squares
estimate of beta.}
\item{Mean.coefs}{"Regression table" for the mean coefficient estimates,
listing the estimate, standard error, and t-value.}
\item{Cov.mat}{Estimated covariance matrix (\code{N.obs} x \code{N.obs})
using all relevant parameter estimates.}
\item{Cov.mat.inv}{Inverse of \code{Cov.mat}, the estimated covariance
matrix (\code{N.obs} x \code{N.obs}).}
\item{aniso.pars}{Vector of MLEs for the anisotropy parameters lam1,
lam2, eta.}
\item{aniso.mat}{2 x 2 anisotropy matrix, calculated from
\code{aniso.pars}.}
\item{tausq.est}{Scalar maximum likelihood estimate of tausq (nugget
variance).}
\item{sigmasq.est}{Scalar maximum likelihood estimate of sigmasq
(process variance).}
\item{kappa.MLE}{Scalar maximum likelihood estimate for kappa (when
applicable).}
\item{cov.model}{String; the correlation model used for estimation.}
\item{coords}{N x 2 matrix of observation locations.}
\item{global.loglik}{Scalar value of the maximized likelihood from the
global optimization (if available).}
\item{Xmat}{Design matrix, obtained from using \code{\link[stats]{lm}}
with \code{mean.model}.}
}
\description{
\code{Aniso_fit} estimates the parameters of the stationary spatial model.
Required inputs are the observed data and locations (a geoR object
with $coords and $data). Optional inputs include the covariance model
(exponential is the default).
}
\examples{
# Using iid standard Gaussian data
aniso.fit <- Aniso_fit( coords = cbind(runif(100), runif(100)),
data = rnorm(100) )
}

