% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate}
\alias{generate}
\title{Generate contribution table}
\usage{
generate(
  data,
  color_map = c("white", "grey", "black"),
  palette_name = "github",
  sort = FALSE,
  show_legend = FALSE,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  caption = NULL,
  tag = NULL,
  font_size_x = 16,
  font_size_y = 16,
  text_angle_x = 30,
  text_angle_y = 0,
  hjust_x = 0.2,
  hjust_y = 1,
  vjust_x = 1,
  vjust_y = 0.5,
  coord_ratio = 1
)
}
\arguments{
\item{data}{a \code{data.frame}. e.g. \code{data("demo")}.}

\item{color_map}{color map for discrete order, either a length-3 vector for 3 contribution level:
None, Minor and Major; or a \code{Scale} object like \code{scale_fill_brewer(palette ="Oranges")}.}

\item{palette_name}{palette_name for plotting continuous contributions.
See \link{show_palette} for available options.}

\item{sort}{if \code{TRUE}, sort the plot to make sure the plot is similar
what input.}

\item{show_legend}{if \code{TRUE}, show figure legend.}

\item{title}{The text for the title.}

\item{xlab}{x axis label.}

\item{ylab}{y axis label.}

\item{caption}{The text for the caption which will be displayed in the
bottom-right of the plot by default.}

\item{tag}{The text for the tag label which will be displayed at the
top-left of the plot by default.}

\item{font_size_x}{font size for x.}

\item{font_size_y}{font size for y.}

\item{text_angle_x}{text angle for x.}

\item{text_angle_y}{text angle for y.}

\item{hjust_x}{hjust for x axis text.}

\item{hjust_y}{hjust for y axis text.}

\item{vjust_x}{vjust for x axis text.}

\item{vjust_y}{vjust for y axis text.}

\item{coord_ratio}{coordinate ratio.}
}
\value{
a \code{ggplot2} object
}
\description{
Generate contribution table
}
\examples{
library(contribution)
library(ggplot2)

# Paper contributions
generate(demo)
generate(demo, text_angle_x = 20, color_map = scale_fill_brewer(palette = "Oranges"))
\donttest{
# Github project contributions
my_contr <- dplyr::tibble(
  repo = c("UCSCXenaTools", "maftools"),
  owner = c("ShixiangWang", "PoisonAlien"),
  username = "ShixiangWang",
  role = c("Developer", "Contributor")
)

my_contr
contr_tb <- pull_github(data = my_contr)

contr_tb

generate(contr_tb, show_legend = TRUE, hjust_x = 0)
generate(contr_tb,
  show_legend = TRUE, hjust_x = 0,
  palette_name = "psychedelic"
)
}
}
