% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_contrast.R
\name{use_contrasts}
\alias{use_contrasts}
\title{Contrast code factors}
\usage{
use_contrasts(
  factor_col,
  code_by = NA,
  reference_level = NA,
  set_intercept = NA,
  drop_trends = NA,
  labels = NULL,
  as_is = FALSE,
  ...
)
}
\arguments{
\item{factor_col}{The factor column to use, eg data$gender}

\item{code_by}{Either a matrix or a function}

\item{reference_level}{The level to use as the reference level, default NA}

\item{set_intercept}{The intercept to use, default NA}

\item{drop_trends}{Whether to drop trends, default NA}

\item{labels}{Labels to use in the contrast matrix, must equal number of
contrasts}

\item{as_is}{Logical, default FALSE, whether to suppress auto switching of
the reference level to the first level if not specified}

\item{...}{Additional arguments to be passed to use_contrast_function,
specifically, which level you want the reference level to be}
}
\value{
A contrast coding matrix with labels and proper reference level
}
\description{
Helper to do contrast coding. There are two options:
\itemize{
\item Manually specify a matrix for code_by (implements use_contrast_matrix).
Reference level is automatically set to the row that's always negative.
\item Specify a style of contrast coding as a function. Label of the reference
level should be specified in ...
}
}
\examples{

# Create a contrast matrix given some factor vector with the specified
# reference level
use_contrasts(gl(5,2), sum_code, reference_level = 3)

# Set column labels; order for labels is the same as the column indices
use_contrasts(gl(3,2), scaled_sum_code, labels = c("2-1", "3-1"))

my_data <- mtcars
my_data$gear <- factor(mtcars$gear)

MASS::fractions(use_contrasts(my_data$gear, helmert_code))

}
