% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald_test_and_CI_common_diff_stratified_2x2.R
\name{Wald_test_and_CI_common_diff_stratified_2x2}
\alias{Wald_test_and_CI_common_diff_stratified_2x2}
\title{The Wald test and CI for a common difference between probabilities}
\usage{
Wald_test_and_CI_common_diff_stratified_2x2(
  n,
  estimatetype = "MH",
  alpha = 0.05
)
}
\arguments{
\item{n}{the observed table (a 2x2xk matrix, where k is the number of strata)}

\item{estimatetype}{Mantel-Haenszel or inverse variance estimate
('MH' or 'IV')}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Wald test and CI for a common difference between
probabilities based on either the Mantel-Haenszel or inverse variance
estimate

Described in Chapter 10 "Stratified 2x2 Tables and Meta-Analysis"
}
\examples{
# Smoking and lung cancer (Doll and Hill, 1950)
Wald_test_and_CI_common_diff_stratified_2x2(doll_hill_1950)

# Prophylactice use of Lidocaine in myocardial infarction (Hine et al., 1989)
Wald_test_and_CI_common_diff_stratified_2x2(hine_1989)

}
