% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_utility.R
\name{invgamma}
\alias{invgamma}
\alias{dinvgamma}
\alias{pinvgamma}
\alias{qinvgamma}
\alias{rinvgamma}
\title{The Inverse Gamma Distribution}
\usage{
dinvgamma(x, shape, rate = 1, scale = 1/rate, log = FALSE)

pinvgamma(q, shape, rate = 1, scale = 1/rate, lower.tail = TRUE, log.p = FALSE)

qinvgamma(p, shape, rate = 1, scale = 1/rate, lower.tail = TRUE, log.p = FALSE)

rinvgamma(n, shape, rate = 1, scale = 1/rate)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape}{inverse gamma shape parameter}

\item{rate}{inverse gamma rate parameter}

\item{scale}{alternative to rate; scale = 1/rate}

\item{log, log.p}{logical; if TRUE, probabilities p are given as
log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P(X <= x) otherwise, P(X > x).}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is
taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random
generation for the inverse gamma distribution.
}
\details{
The inverse gamma distribution with parameters shape and rate has
density \emph{f(x) = rate^shape/Gamma(shape) x^(-1-shape)
e^(-rate/x)} it is the inverse of the standard gamma
parameterization in R.

The functions (d/p/q/r)invgamma simply wrap those of the standard
(d/p/q/r)gamma R implementation, so look at, say,
\code{\link{dgamma}} for details.
}
\examples{

s <- seq(0, 5, .01)
plot(s, dinvgamma(s, 7, 10), type = 'l')

f <- function(x) dinvgamma(x, 7, 10)
q <- 2
integrate(f, 0, q)
(p <- pinvgamma(q, 7, 10))
qinvgamma(p, 7, 10) # = q
mean(rinvgamma(1e5, 7, 10) <= q)
}
