% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-DictS3.R, R/GroupGenericMath.R,
%   R/GroupGenericSummary.R, R/Ops-arithmetic.R, R/Ops-logic.R, R/add.R,
%   R/replace.R, R/update.R
\name{DictS3}
\alias{DictS3}
\alias{dict}
\alias{as.dict}
\alias{is.dict}
\title{A Dictionary}
\usage{
dict(...)

as.dict(x)

is.dict(x)
}
\arguments{
\item{...}{elements put into the \code{Dict}.}

\item{x}{\code{R} object of \code{ANY} type for \code{\link[=as.dict]{as.dict()}} and \code{\link[=is.dict]{is.dict()}}
or of class \code{Dict} for the \code{S3} methods.}
}
\description{
The \link{Dict} initially was developed to resemble Python's
dict type, but by now offers both more features and flexibility, for
example, by providing both associative key-value pair as well as
positional array semantics.
It is implemented as a specialized associative \link{Container} thus sharing
all \link{Container} methods with some of them being adapted to account for
the key-value pair semantic. All elements must be named.
}
\details{
Internally, all key-value pairs are stored in a hash-table and the
elements are sorted lexicographically by their keys.
Methods that alter \code{Dict} objects usually come in two versions
providing either copy or reference semantics where the latter start with
\code{'ref_'} to note the reference semantic, for example, \code{add()} and \code{ref_add()}.

\itemize{
\item \code{dict(...)} initializes and returns an object of class \code{Dict}
}

\itemize{
\item \code{as.dict(x)} coerces \code{x} to a dictionary
}

\itemize{
\item \code{is.dict(x)} returns \code{TRUE} if \code{x} is of class \code{Dict}
and \code{FALSE} otherwise.
}

\itemize{
\item \code{x + y} combines \code{x} and \code{y} into a new dict by updating \code{x}
by \code{y} (see also \verb{[update()]}).
}

\itemize{
\item \code{x - y} removes all keys from \code{x} that appear in \code{y}.
}

\itemize{
\item \code{x} \code{&} \code{y} returns a copy of \code{x} keeping only the keys that
are common in both (key intersection), that is, all keys in \code{x} that do not
exist in \code{y} are removed.
}

\itemize{
\item \code{x} \code{|} \code{y} returns a copy of \code{x} extended by all elements of
\code{y} that are stored at keys (or names) that do not exist in \code{x}, thereby
combining the keys of both objects (set union of keys).
}

\itemize{
\item \code{add(.x, ...)} and \code{ref_add(.x, ...)} adds \code{key = value} pairs to \code{.x}.
If any of the keys already exists, an error is given.
}

\itemize{
\item \code{replace(.x, old, new)} and \code{ref_replace(.x, old)} try to find element \code{old}
and replace it with element \code{new}. If \code{old} does not exist, an error is
raised.
}

\itemize{
\item \code{update(object, other)} and \code{ref_update(object, other)} adds elements of \code{other} dict
for keys not yet in \code{object} and replaces the values of existing keys.
}
}
\examples{
d = dict(b = "one", a = 1, f = mean, na = NA)
print(d)
names(d)

try(dict(a = 1, 2))   # all elements must be named

# Coercion
as.dict(list(A = 1:3, B = "b"))
as.dict(c(x = 1, y = "x", z = 2 + 3))
# Math
d = dict(a = rnorm(1), b = rnorm(1))
abs(d)
cumsum(d)
round(d)
exp(d)

# Summary
range(d)
min(d)
max(d)

d1 = dict(a = 1, b = list(1, 2))
d2 = dict(a = 2, b = list(1, 2))
d1 + d2      # same as update(d, d2)
d2 + d1      # same as update(d2, d)
try({
c(d1, d2)    # duplicated keys are not allowed for Dict
})
d1 - d2
d2 - d1
d1 - d1

d1 = dict(a = 1, b = 2)
d2 = dict(a = 10, x = 4)
d1 & d2      # {a = 1}

d1 | d2      # {a = 1, b = 2, x = 4}


d = dict(a = 1)
add(d, b = 2, co = container(1:3))

try(add(d, a = 7:9))  # key 'a' already in Dict

d = dict(a = 1, b = "z")
replace(d, 1, 1:5)
replace(d, "z", "a")

try({
replace(d, "a", 2)              # old element ("a") is not in Dict
})

d1 = dict(a = 1, b = 2)
d2 = dict(       b = 0, c = 3)
update(d1, d2)  # {a = 1, b = 0, c = 3}
update(d2, d1)  # {a = 1, b = 2, c = 3}
}
\seealso{
See \code{\link[=container]{container()}} for all inherited methods. For the full class
documentation see \link{Dict} and it's superclass \link{Container}.
}
