% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consort_plot.R
\name{consort_plot}
\alias{consort_plot}
\title{Self generating consort diagram}
\usage{
consort_plot(
  data,
  orders,
  side_box,
  allocation = NULL,
  labels = NULL,
  coords = NULL,
  dist = 0.02,
  cex = 0.8,
  text_width = NULL,
  widths = c(0.1, 0.9)
)
}
\arguments{
\item{data}{Data set with disposition information for each participants.}

\item{orders}{A named vector or a list, names as the variable in the dataset
and values as labels in the box. The order of the diagram will be based on this.}

\item{side_box}{Variable vector, appeared as side box in the diagram. The next
box will be the subset of the missing values of these variables.}

\item{allocation}{Name of the grouping/treatment variable (optional), the
diagram will split into branches on this variables forward.}

\item{labels}{Named vector, names is the location of the terminal node. The
position location should plus 1 after the allocation variables if the allocation
is defined.}

\item{coords}{The horizontal coordinates of the boxes, see \link{add_split}.}

\item{dist}{Optional, distance between boxes. Default is 0.02.}

\item{cex}{Multiplier applied to font size, Default is 0.8}

\item{text_width}{a positive integer giving the target column for wrapping
lines in the output. String will not be wrapped if not defined (default).
The \code{\link[stringi]{stri_wrap}} function will be used if \code{stringi}
package installed, otherwise \code{\link[base]{strwrap}} will be used.}

\item{widths}{A numeric vector of length 2 specifying relative percentage
of the label and diagram in the final gprah.}
}
\value{
A \code{consort.plot} object.
}
\description{
Create CONSORT diagram from a participant disposition data.
}
\details{
The calculation of numbers is as in an analogous to Kirchhoff's Laws of
electricity. The numbers in terminal nodes must sum to those in the ancestor
 nodes. All the drop outs will be populated as a side box. Which was different
  from the official CONSORT diagram template, which has dropout inside a
  vertical node.
}
\examples{
## Prepare test data
set.seed(1001)
N <- 300

trialno <- sample(c(1000:2000), N)
exc1 <- rep(NA, N)
exc1[sample(1:N, 15)] <- sample(c("Sample not collected", "MRI not collected", "Other"),
  15,
  replace = TRUE, prob = c(0.4, 0.4, 0.2)
)

induc <- rep(NA, N)
induc[is.na(exc1)] <- trialno[is.na(exc1)]

exc2 <- rep(NA, N)
exc2[sample(1:N, 20)] <- sample(c(
  "Sample not collected", "Dead",
  "Other"
), 20,
replace = TRUE,
prob = c(0.4, 0.4, 0.2)
)
exc2[is.na(induc)] <- NA

exc <- ifelse(is.na(exc2), exc1, exc2)

arm <- rep(NA, N)
arm[is.na(exc)] <- sample(c("Conc", "Seq"), sum(is.na(exc)), replace = TRUE)
arm3 <- sample(c("Trt A", "Trt B", "Trt C"), N, replace = TRUE)
arm3[is.na(arm)] <- NA

fow1 <- rep(NA, N)
fow1[!is.na(arm)] <- sample(c("Withdraw", "Discontinued", "Death", "Other", NA),
  sum(!is.na(arm)),
  replace = TRUE,
  prob = c(0.05, 0.05, 0.05, 0.05, 0.8)
)
fow2 <- rep(NA, N)
fow2[!is.na(arm) & is.na(fow1)] <- sample(c("Protocol deviation", "Outcome missing", NA),
  sum(!is.na(arm) & is.na(fow1)),
  replace = TRUE,
  prob = c(0.05, 0.05, 0.9)
)


df <- data.frame(trialno, exc1, induc, exc2, exc, arm, arm3, fow1, fow2)
rm(trialno, exc1, induc, exc2, exc, arm, arm3, fow1, fow2, N)

## Single arm
out <- consort_plot(
  data = df,
  order = c(
    trialno = "Population",
    exc1 = "Excluded",
    arm = "Allocated",
    fow1 = "Lost of Follow-up",
    trialno = "Finished Followup",
    fow2 = "Not evaluable for the final analysis",
    trialno = "Final Analysis"
  ),
  side_box = c("exc1", "fow1", "fow2"),
  cex = 0.9
)

## Two arms
out <- consort_plot(
  data = df,
  order = c(
    trialno = "Population",
    exc = "Excluded",
    arm = "Randomized patient",
    fow1 = "Lost of Follow-up",
    trialno = "Finished Followup",
    fow2 = "Not evaluable",
    trialno = "Final Analysis"
  ),
  side_box = c("exc", "fow1", "fow2"),
  allocation = "arm",
  labels = c(
    "1" = "Screening", "2" = "Randomization",
    "5" = "Final"
  )
)
## Three arms
consort_plot(
  data = df,
  order = c(
    trialno = "Population",
    exc = "Excluded",
    arm3 = "Randomized patient",
    fow1 = "Lost of Follow-up",
    trialno = "Finished Followup",
    fow2 = "Not evaluable",
    trialno = "Final Analysis"
  ),
  side_box = c("exc", "fow1", "fow2"),
  allocation = "arm3",
  labels = c(
    "1" = "Screening", "2" = "Randomization",
    "5" = "Final"
  )
)

## Multiple phase
consort_plot(
  data = df,
  order = list(
    trialno = "Population",
    exc1 = "Excluded",
    induc = "Induction",
    exc2 = "Excluded",
    arm3 = "Randomized patient",
    fow1 = "Lost of Follow-up",
    trialno = "Finished Followup",
    fow2 = "Not evaluable",
    trialno = "Final Analysis"
  ),
  side_box = c("exc1", "exc2", "fow1", "fow2"),
  allocation = "arm3",
  labels = c(
    "1" = "Screening", "2" = "Month 4",
    "3" = "Randomization", "5" = "Month 24",
    "6" = "End of study"
  ),
  dist = 0.02,
  cex = 0.7
)
}
\seealso{
\code{\link{add_side_box}},\code{\link{add_split}},
\code{\link{add_side_box}}
}
