% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_box.R
\name{connect_box}
\alias{connect_box}
\title{Connect grob box with arrow.}
\usage{
connect_box(start, end, connect, type = c("s", "p"), name = NULL)
}
\arguments{
\item{start}{Starting point of the arrow.}

\item{end}{Ending point of the arrow.}

\item{connect}{The connection of the box. It should be the combination of the
position. The \code{t} refers to "top", \code{l} for "left", \code{b} for
"bottom" and \code{r} for "right". The first letter is the starting point of
the start box, the second is the ending point of the end box. For example, if
one wants to connect the left side of the start box with right side of the
left side of the end box, the value should be \code{"lr"}. All the connection
will be started in the middle point.}

\item{type}{Should be one the \code{"s"} (strait line), or \code{"p"} (polyline).}

\item{name}{A character identifier of the line grob, passed to \code{\link[grid]{linesGrob}}.}
}
\value{
A lines grob with arrow.
}
\description{
This function is used to create an arrow line to connect two boxes. User should
provide the starting and ending side of the arrow.
}
\examples{
fg1 <- textbox(text = "This is a test")
fg2 <- textbox(text = "This is an other test", 0.7, 0.2)
grid::grid.draw(fg1)
grid::grid.draw(fg2)
connect_box(fg1, fg2, connect = "bl", type = "p")
}
