% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_logger_add_logs.R
\name{add_logs}
\alias{add_logs}
\title{Add Logging Capability to Connections}
\usage{
add_logs(connections)
}
\arguments{
\item{connections}{An object of class \code{\link[=connectors]{connectors()}}. This should be a list
of connection objects to which logging capability will be added.}
}
\value{
The modified \code{connections} object with logging capability added.
Each connection in the list will have the "ConnectorLogger" class
prepended to its existing classes.
}
\description{
This function adds logging capability to a list of connections by modifying
their class attributes. It ensures that the input is of the correct type and
registers the necessary S3 methods for logging.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks if the input \code{connections} is of class "connectors".
\item Iterates through each connection in the list and prepends the "ConnectorLogger" class.
}
}
\examples{
con <- connectors(
  sdtm = connector_fs(path = tempdir())
 )

logged_connections <- add_logs(con)

}
