% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runtime-caches.R
\name{delete_runtime_cache}
\alias{delete_runtime_cache}
\title{Delete a runtime cache}
\usage{
delete_runtime_cache(
  client,
  language,
  version,
  image_name = "Local",
  dry_run = FALSE
)
}
\arguments{
\item{client}{A \code{Connect} object.}

\item{language}{The language of the cache, either "R" or "Python".}

\item{version}{The version of the cache, e.g. "4.3.3".}

\item{image_name}{Optional. The name of the off-host execution image for
the cache, or "Local" (the default) for native execution caches.}

\item{dry_run}{Optional, default \code{FALSE}. If true, perform a dry run of
the deletion.}
}
\value{
A \code{Task} object representing the deletion task. If \code{dry_run} is
\code{TRUE}, returns \code{NULL} or throws an error if the deletion would fail.
}
\description{
Delete a runtime cache from a Connect server.
Requires Administrator privileges.
}
\examples{
\dontrun{
client <- connect()
task <- delete_runtime_cache(client, "R", "4.3.3")
poll_task(task)
}

}
\seealso{
\code{\link[=get_runtime_caches]{get_runtime_caches()}}

Other server management functions: 
\code{\link{get_runtime_caches}()}
}
\concept{server management functions}
