% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{RStudioConnect}
\alias{RStudioConnect}
\alias{Connect}
\title{Class representing a Connect API client}
\description{
Class representing a Connect API client

Class representing a Connect API client
}
\section{Usage}{

\preformatted{
client <- Connect$new(server = 'connect.example.com',
  apiKey = 'mysecretkey')
client$get_apps()
client$get_tags()
}
}

\section{Details}{


This class allows a user to interact with a Connect server via the Connect
API. Authentication is done by providing an API key.
}

\seealso{
Other R6 classes: 
\code{\link{Bundle}},
\code{\link{ContentTask}},
\code{\link{Content}},
\code{\link{Environment}},
\code{\link{Task}},
\code{\link{Vanity}},
\code{\link{VariantSchedule}},
\code{\link{VariantTask}},
\code{\link{Variant}}
}
\concept{R6 classes}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Connect-get_connect}{\code{Connect$get_connect()}}
\item \href{#method-Connect-new}{\code{Connect$new()}}
\item \href{#method-Connect-httr_config}{\code{Connect$httr_config()}}
\item \href{#method-Connect-print}{\code{Connect$print()}}
\item \href{#method-Connect-raise_error}{\code{Connect$raise_error()}}
\item \href{#method-Connect-add_auth}{\code{Connect$add_auth()}}
\item \href{#method-Connect-GET}{\code{Connect$GET()}}
\item \href{#method-Connect-GET_RESULT}{\code{Connect$GET_RESULT()}}
\item \href{#method-Connect-GET_URL}{\code{Connect$GET_URL()}}
\item \href{#method-Connect-GET_RESULT_URL}{\code{Connect$GET_RESULT_URL()}}
\item \href{#method-Connect-PUT}{\code{Connect$PUT()}}
\item \href{#method-Connect-HEAD}{\code{Connect$HEAD()}}
\item \href{#method-Connect-DELETE}{\code{Connect$DELETE()}}
\item \href{#method-Connect-PATCH}{\code{Connect$PATCH()}}
\item \href{#method-Connect-POST}{\code{Connect$POST()}}
\item \href{#method-Connect-me}{\code{Connect$me()}}
\item \href{#method-Connect-get_dashboard_url}{\code{Connect$get_dashboard_url()}}
\item \href{#method-Connect-get_tags}{\code{Connect$get_tags()}}
\item \href{#method-Connect-get_tag_id}{\code{Connect$get_tag_id()}}
\item \href{#method-Connect-get_tag_tree}{\code{Connect$get_tag_tree()}}
\item \href{#method-Connect-get_tag_tree_old}{\code{Connect$get_tag_tree_old()}}
\item \href{#method-Connect-tag_create_safe}{\code{Connect$tag_create_safe()}}
\item \href{#method-Connect-tag_create}{\code{Connect$tag_create()}}
\item \href{#method-Connect-tag}{\code{Connect$tag()}}
\item \href{#method-Connect-tag_delete}{\code{Connect$tag_delete()}}
\item \href{#method-Connect-get_n_apps}{\code{Connect$get_n_apps()}}
\item \href{#method-Connect-get_apps}{\code{Connect$get_apps()}}
\item \href{#method-Connect-get_schedule}{\code{Connect$get_schedule()}}
\item \href{#method-Connect-content_create}{\code{Connect$content_create()}}
\item \href{#method-Connect-download_bundle}{\code{Connect$download_bundle()}}
\item \href{#method-Connect-bundle_delete}{\code{Connect$bundle_delete()}}
\item \href{#method-Connect-content_upload}{\code{Connect$content_upload()}}
\item \href{#method-Connect-content_deploy}{\code{Connect$content_deploy()}}
\item \href{#method-Connect-content}{\code{Connect$content()}}
\item \href{#method-Connect-task}{\code{Connect$task()}}
\item \href{#method-Connect-set_content_tag}{\code{Connect$set_content_tag()}}
\item \href{#method-Connect-user}{\code{Connect$user()}}
\item \href{#method-Connect-users}{\code{Connect$users()}}
\item \href{#method-Connect-users_remote}{\code{Connect$users_remote()}}
\item \href{#method-Connect-users_create}{\code{Connect$users_create()}}
\item \href{#method-Connect-users_create_remote}{\code{Connect$users_create_remote()}}
\item \href{#method-Connect-users_lock}{\code{Connect$users_lock()}}
\item \href{#method-Connect-users_unlock}{\code{Connect$users_unlock()}}
\item \href{#method-Connect-users_update}{\code{Connect$users_update()}}
\item \href{#method-Connect-groups}{\code{Connect$groups()}}
\item \href{#method-Connect-group_members}{\code{Connect$group_members()}}
\item \href{#method-Connect-group_member_add}{\code{Connect$group_member_add()}}
\item \href{#method-Connect-group_member_remove}{\code{Connect$group_member_remove()}}
\item \href{#method-Connect-groups_create}{\code{Connect$groups_create()}}
\item \href{#method-Connect-groups_create_remote}{\code{Connect$groups_create_remote()}}
\item \href{#method-Connect-groups_remote}{\code{Connect$groups_remote()}}
\item \href{#method-Connect-inst_content_visits}{\code{Connect$inst_content_visits()}}
\item \href{#method-Connect-inst_shiny_usage}{\code{Connect$inst_shiny_usage()}}
\item \href{#method-Connect-procs}{\code{Connect$procs()}}
\item \href{#method-Connect-repo_account}{\code{Connect$repo_account()}}
\item \href{#method-Connect-repo_branches}{\code{Connect$repo_branches()}}
\item \href{#method-Connect-repo_manifest_dirs}{\code{Connect$repo_manifest_dirs()}}
\item \href{#method-Connect-schedules}{\code{Connect$schedules()}}
\item \href{#method-Connect-docs}{\code{Connect$docs()}}
\item \href{#method-Connect-audit_logs}{\code{Connect$audit_logs()}}
\item \href{#method-Connect-server_settings_r}{\code{Connect$server_settings_r()}}
\item \href{#method-Connect-server_settings}{\code{Connect$server_settings()}}
\item \href{#method-Connect-clone}{\code{Connect$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-get_connect"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-get_connect}{}}}
\subsection{Method \code{get_connect()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$get_connect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-new"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$new(server, api_key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-httr_config"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-httr_config}{}}}
\subsection{Method \code{httr_config()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$httr_config(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-print"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$print(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-raise_error"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-raise_error}{}}}
\subsection{Method \code{raise_error()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$raise_error(res)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-add_auth"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-add_auth}{}}}
\subsection{Method \code{add_auth()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$add_auth()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-GET"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-GET}{}}}
\subsection{Method \code{GET()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$GET(path, writer = httr::write_memory(), parser = "parsed", ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-GET_RESULT"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-GET_RESULT}{}}}
\subsection{Method \code{GET_RESULT()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$GET_RESULT(path, writer = httr::write_memory(), ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-GET_URL"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-GET_URL}{}}}
\subsection{Method \code{GET_URL()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$GET_URL(url, writer = httr::write_memory(), parser = "parsed", ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-GET_RESULT_URL"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-GET_RESULT_URL}{}}}
\subsection{Method \code{GET_RESULT_URL()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$GET_RESULT_URL(url, writer = httr::write_memory(), ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-PUT"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-PUT}{}}}
\subsection{Method \code{PUT()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$PUT(path, body, encode = "json", ..., .empty_object = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-HEAD"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-HEAD}{}}}
\subsection{Method \code{HEAD()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$HEAD(path, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-DELETE"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-DELETE}{}}}
\subsection{Method \code{DELETE()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$DELETE(path, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-PATCH"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-PATCH}{}}}
\subsection{Method \code{PATCH()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$PATCH(
  path,
  body,
  encode = "json",
  prefix = "/__api__/",
  ...,
  .empty_object = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-POST"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-POST}{}}}
\subsection{Method \code{POST()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$POST(
  path,
  body,
  encode = "json",
  prefix = "/__api__/",
  ...,
  .empty_object = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-me"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-me}{}}}
\subsection{Method \code{me()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$me()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-get_dashboard_url"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-get_dashboard_url}{}}}
\subsection{Method \code{get_dashboard_url()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$get_dashboard_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-get_tags"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-get_tags}{}}}
\subsection{Method \code{get_tags()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$get_tags(use_cache = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-get_tag_id"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-get_tag_id}{}}}
\subsection{Method \code{get_tag_id()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$get_tag_id(tagname)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-get_tag_tree"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-get_tag_tree}{}}}
\subsection{Method \code{get_tag_tree()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$get_tag_tree()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-get_tag_tree_old"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-get_tag_tree_old}{}}}
\subsection{Method \code{get_tag_tree_old()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$get_tag_tree_old()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-tag_create_safe"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-tag_create_safe}{}}}
\subsection{Method \code{tag_create_safe()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$tag_create_safe(name, parent_id = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-tag_create"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-tag_create}{}}}
\subsection{Method \code{tag_create()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$tag_create(name, parent_id = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-tag"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-tag}{}}}
\subsection{Method \code{tag()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$tag(id = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-tag_delete"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-tag_delete}{}}}
\subsection{Method \code{tag_delete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$tag_delete(id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-get_n_apps"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-get_n_apps}{}}}
\subsection{Method \code{get_n_apps()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$get_n_apps()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-get_apps"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-get_apps}{}}}
\subsection{Method \code{get_apps()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$get_apps(filter = NULL, .collapse = "&", .limit = Inf, page_size = 25)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-get_schedule"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-get_schedule}{}}}
\subsection{Method \code{get_schedule()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$get_schedule(schedule_id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-content_create"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-content_create}{}}}
\subsection{Method \code{content_create()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$content_create(name, title = name, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-download_bundle"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-download_bundle}{}}}
\subsection{Method \code{download_bundle()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$download_bundle(bundle_id, to_path = tempfile(), overwrite = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-bundle_delete"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-bundle_delete}{}}}
\subsection{Method \code{bundle_delete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$bundle_delete(bundle_id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-content_upload"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-content_upload}{}}}
\subsection{Method \code{content_upload()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$content_upload(bundle_path, guid)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-content_deploy"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-content_deploy}{}}}
\subsection{Method \code{content_deploy()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$content_deploy(guid, bundle_id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-content"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-content}{}}}
\subsection{Method \code{content()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$content(
  guid = NULL,
  owner_guid = NULL,
  name = NULL,
  include = "tags,owner"
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-task"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-task}{}}}
\subsection{Method \code{task()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$task(task_id, first = 0, wait = 5)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-set_content_tag"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-set_content_tag}{}}}
\subsection{Method \code{set_content_tag()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$set_content_tag(content_id, tag_id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-user"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-user}{}}}
\subsection{Method \code{user()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$user(guid)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-users"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-users}{}}}
\subsection{Method \code{users()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$users(page_number = 1, prefix = NULL, page_size = 20)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-users_remote"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-users_remote}{}}}
\subsection{Method \code{users_remote()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$users_remote(prefix)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-users_create"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-users_create}{}}}
\subsection{Method \code{users_create()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$users_create(
  username,
  email,
  first_name = NULL,
  last_name = NULL,
  password = NULL,
  user_must_set_password = NULL,
  user_role = NULL,
  unique_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-users_create_remote"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-users_create_remote}{}}}
\subsection{Method \code{users_create_remote()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$users_create_remote(temp_ticket)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-users_lock"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-users_lock}{}}}
\subsection{Method \code{users_lock()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$users_lock(user_guid)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-users_unlock"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-users_unlock}{}}}
\subsection{Method \code{users_unlock()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$users_unlock(user_guid)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-users_update"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-users_update}{}}}
\subsection{Method \code{users_update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$users_update(user_guid, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-groups"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-groups}{}}}
\subsection{Method \code{groups()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$groups(page_number = 1, prefix = NULL, page_size = 20)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-group_members"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-group_members}{}}}
\subsection{Method \code{group_members()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$group_members(guid)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-group_member_add"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-group_member_add}{}}}
\subsection{Method \code{group_member_add()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$group_member_add(group_guid, user_guid)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-group_member_remove"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-group_member_remove}{}}}
\subsection{Method \code{group_member_remove()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$group_member_remove(group_guid, user_guid)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-groups_create"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-groups_create}{}}}
\subsection{Method \code{groups_create()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$groups_create(name)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-groups_create_remote"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-groups_create_remote}{}}}
\subsection{Method \code{groups_create_remote()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$groups_create_remote(temp_ticket)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-groups_remote"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-groups_remote}{}}}
\subsection{Method \code{groups_remote()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$groups_remote(prefix = NULL, limit = 20)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-inst_content_visits"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-inst_content_visits}{}}}
\subsection{Method \code{inst_content_visits()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$inst_content_visits(
  content_guid = NULL,
  min_data_version = NULL,
  from = NULL,
  to = NULL,
  limit = 20,
  previous = NULL,
  nxt = NULL,
  asc_order = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-inst_shiny_usage"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-inst_shiny_usage}{}}}
\subsection{Method \code{inst_shiny_usage()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$inst_shiny_usage(
  content_guid = NULL,
  min_data_version = NULL,
  from = NULL,
  to = NULL,
  limit = 20,
  previous = NULL,
  nxt = NULL,
  asc_order = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-procs"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-procs}{}}}
\subsection{Method \code{procs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$procs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-repo_account"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-repo_account}{}}}
\subsection{Method \code{repo_account()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$repo_account(host)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-repo_branches"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-repo_branches}{}}}
\subsection{Method \code{repo_branches()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$repo_branches(repo)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-repo_manifest_dirs"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-repo_manifest_dirs}{}}}
\subsection{Method \code{repo_manifest_dirs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$repo_manifest_dirs(repo, branch)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-schedules"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-schedules}{}}}
\subsection{Method \code{schedules()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$schedules(
  start = Sys.time(),
  end = Sys.time() + 60 * 60 * 24 * 7,
  detailed = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-docs"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-docs}{}}}
\subsection{Method \code{docs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$docs(docs = "api", browse = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-audit_logs"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-audit_logs}{}}}
\subsection{Method \code{audit_logs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$audit_logs(limit = 20L, previous = NULL, nxt = NULL, asc_order = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-server_settings_r"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-server_settings_r}{}}}
\subsection{Method \code{server_settings_r()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$server_settings_r()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-server_settings"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-server_settings}{}}}
\subsection{Method \code{server_settings()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$server_settings()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Connect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
