% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cham_votes.R
\name{cham_votes}
\alias{cham_votes}
\title{Downloads votes of a specific bill by providing type, number and year}
\usage{
cham_votes(type, number, year, ascii = TRUE)
}
\arguments{
\item{type}{\code{character}. The type of the bill. For example, "PL" for law proposal ("projeto de lei"),
"PEC" for constitutional ammendments ("projeto de emenda constitucional"), "PDC" for legislative decree ("decreto legislativo"),
and "PLP" for supplementary laws ("projeto de lei complementar).}

\item{number}{\code{integer}. The number of the bill.}

\item{year}{\code{integer}. The year of the bill.}

\item{ascii}{\code{logical}. If TRUE, certain strings are converted to ascii format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Downloads votes of a specific bill by providing type, number and year. A bill can have more than one roll call,
and the API does not provide an id to identify them So we provide one (rollcall_id).
}
\note{
Requesting data from a long period of time with \code{details = TRUE} will
return a large object in terms of memory. It will also be rather unwieldy, with
many columns.
}
\examples{
cham_votes(type = "PL", number = "1992", year = "2007")
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
