% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/house_communication.R
\name{cong_house_communication}
\alias{cong_house_communication}
\title{Request House Communication Information}
\usage{
cong_house_communication(
  congress = NULL,
  type = NULL,
  number = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. 81 or later are supported.}

\item{type}{Type of communication. Can be \code{'ec'}, \code{'ml'}, \code{'pm'}, or \code{'pt'}.}

\item{number}{Communication assigned number. Numeric.}

\item{from_date}{start date for search, e.g. \code{'2022-04-01'}. Defaults to most recent.}

\item{to_date}{end date for search, e.g. \code{'2022-04-03'}. Defaults to most recent.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
\code{tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request House Communication Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Requires API Key

cong_house_communication()

cong_house_communication(congress = 117)

cong_house_communication(congress = 117, type = 'ec')

cong_house_communication(congress = 117, type = 'ec', number = 3324)
\dontshow{\}) # examplesIf}
}
