% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFunctions_1_0_2.r
\name{balance}
\alias{balance}
\title{Function to create a balance table for a specified diagnostic. Takes input from lengthen() or omit.history().}
\usage{
balance(input, diagnostic, approach = "none", censoring, scope,
  times.exposure, times.covariate, exposure, history = NULL,
  weight.exposure = NULL, weight.censor = NULL, strata = NULL,
  recency = NULL, average.over = NULL, periods = NULL,
  list.distance = NULL, sort.order = "alphabetical", loop = "no",
  ignore.missing.metric = "no", metric = "SMD", sd.ref = "no")
}
\arguments{
\item{input}{a restructured tidy dataframe output from lengthen() or omit.history()}

\item{diagnostic}{diagnostic of interest e.g. 1, 2, or 3}

\item{approach}{adjustment method e.g. "none" or "weight" or "stratify"}

\item{censoring}{use censoring indicators/weights e.g. "yes" or "no"}

\item{scope}{report the entire trellis e.g. "all", the diagonal e.g. "recent", or a summary e.g. "average"}

\item{times.exposure}{vector of exposure measurement times e.g. c(0,1,2)}

\item{times.covariate}{vector of covariate measurement times e.g. c(0,1,2)}

\item{exposure}{root name of exposure e.g. "a"}

\item{history}{root name of exposure history e.g. "h"}

\item{weight.exposure}{root name of IP exposure weights e.g. "wa"}

\item{weight.censor}{root name of IP censoring weights e.g. "ws"}

\item{strata}{root name of propensity-score strata e.g. "e"}

\item{recency}{an integer for the relative distance between exposures and covariate measurements to focus on (e.g. 0 would represent the same timing). The default is 0 for Diagnostics 1 and 3, and 1 for Diagnostic 2}

\item{average.over}{summary level for average metrics e.g. standardize over "values" or "history" or "time" or "distance"}

\item{periods}{a list of contiguous segments of relative distance to pool over e.g. list(0,1:4,5:10) would yield summaries over three segments}

\item{list.distance}{a vector of distances to retain after averaging over time e.g. c(0,2)}

\item{sort.order}{vector of root names for all covariates listed in the order in whcihc they should appear in the table (and also plot) e.g. c("n","m","o","l","p"). To display covariates in alphabetical order (the default), leave blank or type "alphabetical"}

\item{loop}{a housekeeping argument the user can ignore. It is automatically set when the balance function is called by the diagnose() function described later. The default is set to "no".}

\item{ignore.missing.metric}{"yes" or "no" depending on whether the user wishes to estimate averages over person-time when there are missing values of the mean difference or standardized mean difference. Missing values for the standardized mean difference can occur when, for example, there is no covariate variation within levels of exposure-history and measurement times. If this argument is set to "no" and there are missing values, the average will also be missing. If set to "yes" an average will be produced that ignores missing values.}

\item{metric}{the metric for which the user wishes to ignore missing values as specified in the 'ignore.missing.metric' argument.}

\item{sd.ref}{"yes" or "no" depending on whether the user wishes to use the standard deviation of the reference group when calculating the SMD.}
}
\value{
A dataframe depicting a covariate balance table. If the
argument \code{scope} does not equal "average" the returned table
reports the mean difference \code{D} as well as the standardized
mean difference \code{SMD} across levels of exposure, for each
comparison of a non-referent value of exposure \code{E} vs. the
referent value (the lowest value by default) at each pairing of exposure
measurement times \code{time.covariate} and covariate measurement
times \code{time.covariate} within levels of exposure history \code{H}
(and/or strata \code{S}). The sample size of the non-referent group \code{Nexp}
and the sample size summed across the non-referent and referent groups
\code{N} used in the computation of \code{D} or \code{SMD} are also
provided within levels of \code{H} and/or \code{S}. If the argument
\code{scope} equals "average" and the argument \code{average.over} equals
either "values" or "history" or "strata" the format is the same with the
averaged over column removed. If the argument \code{scope} equals "average"
and the argument \code{average.over} equals "time" then a column \code{distance}
indicating the time between exposure and covariate measurements will be
included. If the arguement for \code{scope} equals "average" and the argument
for \code{average.over} equals "distance" then the columns \code{period.start}
and \code{period.end} indicating the beginning and end of person-time
segments will appear.
}
\description{
Function to create a balance table for a specified diagnostic. Takes input from lengthen() or omit.history().
}
\details{
When using the balance(), diagnose(), or  apply.scope() functions, specifying average.over="average" and average.over="time" will return balance metrics for each "distance" value. The output can be subset to specific distances of interest e.g. k=0 and k=2 by supplying a vector to list.distance e.g. c(0,2) but this is optional. Specifying average.over="distance", you can opt to average within segments of distance using the periods argument (leaving this blank will average over all distance values). The periods argument requires a list of contiguous numeric vectors e.g. list(0,1:4,5:10). For Diagnostic 3 this would report metrics at time t, averages over times t-1 to t-4, and averages over times t-5 to t-10. For Diagnostics 1 and 3 the entire range should lie between 0 and t. For Diagnostic 2 the entire range should lie between 1 and t.
}
\examples{
# Simulate the output of lengthen() or omit.history()
id <- as.numeric(rep(c(1,1,1,2,2,2), 70))
time.exposure <- as.numeric(rep(c(0,1,2), 140))
a <- as.character(rep(c(0,1,1,1,0,0), 70))
h <- as.character(rep(c("H","H0","H01","H","H0","H01"), 70))
name.cov <- as.character(c(rep("n",60), rep("l",180), rep("m",180)))
time.covariate <- as.numeric(rep(c(rep(0,7), rep(1,7), rep(2,7)), 60))
value.cov <- as.numeric(rnorm(420, 2, 3))

mydata.long.omit <- data.frame(id, time.exposure, a, h,
                               name.cov, time.covariate, value.cov)


# Run the balance() function
mytable <- balance(input=mydata.long.omit,
                   diagnostic=1,
                   approach="none",
                   censoring="no",
                   scope="all",
                   times.exposure=c(0,1,2),
                   times.covariate=c(0,1),
                   sort.order=c("l","m","n"),
                   exposure="a",
                   history="h"
                   )
}
