% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fungible.R
\encoding{UTF-8}
\name{fungible.lm}
\alias{fungible.lm}
\title{Locate extrema of fungible OLS regression weights}
\usage{
\method{fungible}{lm}(object, theta = 0.005, Nstarts = 1000,
  MaxMin = c("min", "max"), silent = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object of class "lm" or "summary.lm".}

\item{theta}{A vector of values to decrement from R-squared to compute families of fungible coefficients.}

\item{Nstarts}{Maximum number of (max) minimizations from random starting configurations.}

\item{MaxMin}{Should the cosine between the observed and alternative weights be maximized ("max") to find the maximally similar coefficients or minimized ("min") to find the maximally dissimilar coefficients?}

\item{silent}{Should current optimization values be printed to the console (\code{FALSE}) or suppressed (\code{TRUE})?}

\item{...}{Additional arguments}
}
\value{
A list containing the alternative weights and other fungible weights estimation parameters
}
\description{
Identify maximally similar or dissimilar sets of fungible standardized regression coefficients from an OLS regression model
}
\examples{
lm_mtcars <- lm(mpg ~ cyl + disp + hp + drat + wt + qsec + vs + am + gear + carb,
                data = mtcars)
lm_mtcars_fung <- fungible(lm_mtcars, Nstarts = 100)
}
\references{
Waller, N. G., & Jones, J. A. (2009).
Locating the extrema of fungible regression weights.
\emph{Psychometrika, 74}(4), 589–602. \url{https://doi.org/10/c3wbtd}
}
