#' conf: Visualization and Analysis of Statistical Measures of Confidence
#'
#' @description
#' Enables:
#' \enumerate{
#' \item confidence region plots in two-dimensions corresponding to a user given dataset,
#' level of significance, and parametric probability distribution (supported distribution suffixes:
#' gamma, invgauss, lnorm, llogis, norm, weibull), and
#' \item calculating confidence intervals and the associated actual coverage for binomial proportions.
#' }
#'
#' \bold{Request from authors}: We welcome and appreciate your feedback and insights
#' as to how this resource is being leveraged to improve whatever it is you do.  Please include your name
#' and adedemic and/or business affiliation in your correspondance.
#'
#' @details
#' This package includes the functions:
#' \itemize{
#' \item confidence region plots: \code{\link{crplot}},
#' \item confidence intervals for binomial proportions: \code{\link{binomTest}},
#' \item actual coverage calculation for binomial proportions: \code{\link{binomTestCoverage}},
#' \item coverage plots for binomial proportions: \code{\link{binomTestCoveragePlot}}, and
#' \item ensemble confidence intervals for binomial proportions: \code{\link{binomTestEnsemble}}.
#' }
#'
#' @section Acknowledgments:
#' The lead author thanks The Omar Bradley Fellowship for Research in Mathematics for funding that partially
#' supported this work.
#'
#' @author
#' Christopher Weld, Hayeon Park, Larry Leemis
#'
#' Maintainer: Christopher Weld <ceweld@email.wm.edu>
#'
#' @docType package
#' @name conf

NULL
