% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csRobustnessPlot.R
\name{csRobustnessPlot}
\alias{csRobustnessPlot}
\title{Plot robustness results}
\usage{
csRobustnessPlot(
  cs1,
  cs2,
  group = NULL,
  data = NULL,
  alternative = "two.sided",
  conf.level = 0.95,
  mu = 0,
  rscaleSens = c("medium", "wide", "ultrawide"),
  BF01 = TRUE,
  ylimz = c(0, 10),
  sensitivity = FALSE
)
}
\arguments{
\item{cs1}{a numeric vector of values. If the \code{data} argument is
defined, it can refer to either the column index or the column name of
the data object. See \code{Details} for more information.}

\item{cs2}{a numeric vector of values. If the \code{data} argument is
defined, it can refer to either the column index or the column name of
the data object. See \code{Details} for more information.}

\item{group}{column index or name that contain the group data. See
\code{Details} for more information.}

\item{data}{numeric matrix or data frame that contains the relevant data.}

\item{alternative}{a character string for the specification of
the alternative hypothesis. Possible values: \code{"two.sided"} (default),
\code{"greater"} or \code{"less"}.}

\item{conf.level}{Interval's confidence level.}

\item{mu}{a numeric value for the mean value or mean difference.}

\item{rscaleSens}{the scale factor for the prior used in the Bayesian t.test}

\item{BF01}{Should the BF01 be plotted (default is set to TRUE). If FALSE,
the BF10 is plotted.}

\item{ylimz}{the limits of the y-axis.}

\item{sensitivity}{Should the sensitivity results be returned (default is set
to FALSE).}
}
\description{
Plots the results of robustness test
}
\details{
This plot template is influenced by the JASP way
(\url{https://jasp-stats.org/}) for plotting sensitivity analysis results. On the
x-axis or the width of the Cauchy's Scale is plotted. On the y-axis either
BF01 is plotted (if \code{BF01} is set to TRUE) or
BF10 (if \code{BF01} is set to FALSE).
}
\examples{
set.seed(1000)
csRobustnessPlot(cs1 = rnorm(n = 100, mean = 10),
cs2 = rnorm(n = 100, mean = 9))
}
\references{
JASP Team (2019). JASP (Version 0.11.1)[Computer software].

Krypotos, A. M., Klugkist, I., & Engelhard, I. M. (2017). 
Bayesian hypothesis testing for human threat conditioning research: 
An introduction and the condir R package. 
European Journal of Psychotraumatology, 8.
}
\seealso{
\code{\link[condir]{csCompare}}, \code{\link[condir]{csSensitivity}}
}
