% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_table.R
\name{draw_table_html}
\alias{draw_table_html}
\title{Draws an html table from comp_tsout_ens or mv_tsout_ens output.}
\usage{
draw_table_html(obj, uniq_dates = NULL)
}
\arguments{
\item{obj}{The output from \code{comp_tsout_ens} or \code{mv_tsout_ens} functions.}

\item{uniq_dates}{An optional parameter to pass in the dates for the dataset.}
}
\description{
Draws an html table from comp_tsout_ens or mv_tsout_ens output.
}
\examples{
\dontrun{
set.seed(100)
n <- 600
x <- sample(1:100, n, replace=TRUE)
x[25] <- 200
x[320] <- 300
x2 <- sample(1:100, n, replace=TRUE)
x3 <- sample(1:100, n, replace=TRUE)
x4 <- sample(1:100, n, replace=TRUE)
X <- cbind.data.frame(x, x2, x3, x4)
out <- mv_tsout_ens(X, compr=2, fast=FALSE)
draw_table_html(out)
}

}
