% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medians.R
\name{wmedian}
\alias{wmedian}
\title{Weighted Median}
\usage{
wmedian(x, w = rep(1, length(x)))
}
\arguments{
\item{x}{numeric, a vector containing the data from which to calculate the weighted median.}

\item{w}{numeric, a vector of weights to give the data in x.}
}
\value{
numeric. The weighted median of \code{x} using \code{w} as the weights.
}
\description{
This calculates the weighted median of a vector \code{x} using the weights in \code{w}. Weights are re-scaled based on their sum.
}
\details{
Sorts \code{x} and \code{w} by size of the elements of \code{x}. Then re-scales the elements of \code{w} to be between 0 and 1.
Then sets n equal to the sum of all scaled weights with values less than 0.5. If the (n+1)-th element of the
rescaled weights is greater than 0.5, the weighted median is the (n+1)-th element of the sorted \code{x}. Otherwise
it is the average of the (n+1)-th and (n+2)-th elements of the sorted \code{x}.
}
\note{
This is not compatible with complex data.
}
\examples{
xx <- rnorm(10, 4L, 1.5)
ww <- runif(10)
wmedian(xx, ww)

}
\references{
F. Y. Edgeworth, XXII. On a New Method of Reducing Observations Relating to Several Quantities, (1888).
Also see the Wikipedia article on weighted median for a very good explanation and a model algorithm.
}
\seealso{
\link[stats:median]{stats::median}
}
