% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BaselearnerCustomCpp}
\alias{BaselearnerCustomCpp}
\title{Create custom cpp base-learner factory by using cpp functions and external
pointer.}
\format{\code{\link{S4}} object.}
\description{
\code{BaselearnerCustomCpp} creates a custom base-learner factory by
  setting custom \code{C++} functions. This factory object can be registered
  within a base-learner list and then used for training.
}
\section{Usage}{

\preformatted{
BaselearnerCustomCpp$new(data_source, data_target, instantiate_data_ptr,
  train_ptr, predict_ptr)
}
}

\section{Arguments}{

\describe{
\item{\code{data_source} [\code{Data} Object]}{
  Data object which contains the source data.
}
\item{\code{data_target} [\code{Data} Object]}{
  Data object which gets the transformed source data.
}
\item{\code{instantiate_data_ptr} [\code{externalptr}]}{
  External pointer to the \code{C++} instantiate data function.
}
\item{\code{train_ptr} [\code{externalptr}]}{
  External pointer to the \code{C++} train function.
}
\item{\code{predict_ptr} [\code{externalptr}]}{
  External pointer to the \code{C++} predict function.
}
}
}

\section{Details}{

  For an example see the extending compboost vignette or the function
  \code{getCustomCppExample}.

  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classblearnerfactory_1_1_custom_cpp_blearner_factory.html}.
}

\section{Fields}{

  This class doesn't contain public fields.
}

\section{Methods}{

\describe{
\item{\code{getData()}}{Get the data matrix of the target data which is used
  for modeling.}
\item{\code{transformData(X)}}{Transform a data matrix as defined within the
  factory. The argument has to be a matrix with one column.}
\item{\code{summarizeFactory()}}{Summarize the base-learner factory object.}
}
}

\examples{
\donttest{
# Sample data:
data.mat = cbind(1, 1:10)
y = 2 + 3 * 1:10

# Create new data object:
data.source = InMemoryData$new(data.mat, "my.data.name")
data.target = InMemoryData$new()

# Source the external pointer exposed by using XPtr:
Rcpp::sourceCpp(code = getCustomCppExample(silent = TRUE))

# Create new linear base-learner:
custom.cpp.factory = BaselearnerCustomCpp$new(data.source, data.target,
  dataFunSetter(), trainFunSetter(), predictFunSetter())

# Get the transformed data:
custom.cpp.factory$getData()

# Summarize factory:
custom.cpp.factory$summarizeFactory()

# Transform data manually:
custom.cpp.factory$transformData(data.mat)
}
}
