% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hype.R
\name{hype}
\alias{hype}
\title{Hyperparameter optimization}
\usage{
hype(
  eval_func,
  ...,
  X0 = NULL,
  Z0 = NULL,
  n_lhs,
  extract_output_func,
  verbose = 1,
  model = "GauPro",
  covtype = "matern5_2",
  nugget.estim = TRUE
)
}
\arguments{
\item{eval_func}{The function we evaluate.}

\item{...}{Pass in hyperparameters, such as par_unif()
as unnamed arguments.}

\item{X0}{A data frame of initial points to include. They must
have the same names as the hyperparameters. If Z0 is also passed,
it should match the points in X0. If Z0 is not passed,
then X0 will be the first points evaluated.}

\item{Z0}{A vector whose values are the result of applying `eval_func`
to each row of X0.}

\item{n_lhs}{The number of random points to start with. They are
selected using a Latin hypercube sample.}

\item{extract_output_func}{A function that takes in the output from
`eval_func` and returns the value we are trying to minimize.}

\item{verbose}{How much should be printed? 0 is none, 1 is standard,
2 is more, 5+ is a lot}

\item{model}{What kind of model to use.}

\item{covtype}{The covariance function to use for the Gaussian
process model.}

\item{nugget.estim}{Whether a nugget should be estimated when
fitting the Gaussian process model.}
}
\description{
Hyperparameter optimization
}
\examples{

# Have df output, but only use one value from it
h1 <- hype(
  eval_func = function(a, b) {data.frame(c=a^2+b^2, d=1:2)},
  extract_output_func = function(odf) {odf$c[1]},
  a = par_unif('a', -1, 2),
  b = par_unif('b', -10, 10),
  n_lhs = 10
)
h1$run_all()
h1$add_EI(n = 1)
h1$run_all()
#system.time(h1$run_EI_for_time(sec=3, batch_size = 1))
#system.time(h1$run_EI_for_time(sec=3, batch_size = 3))
h1$plotorder()
h1$plotX()
}
