flipBox <- 
function (..., back_content, id, front_title = NULL, back_title = NULL, 
          front_btn_text = "More", back_btn_text = "Back to main", 
          header_img = NULL, main_img = NULL, width = 6) 
{
  id_front <- id
  id_back <- id_front + 10000
  if (is.null(id)) 
    stop("card id cannot be null and must be unique")
  flipBoxTag <- shiny::tags$div(class = paste0("col sm-", 
                                               width), shiny::tags$div(class = "rotate-container", 
                                                                       shiny::tags$div(class = paste0("card card-front-", id, 
                                                                                                      " text-center"), style = "background-color: #ffffff;", 
                                                                                       shiny::tags$div(class = paste0("card-background-", 
                                                                                                                      id)), shiny::tags$div(class = "card-block", style="margin-top:-15%",
                                                                                                                                            shiny::tags$img(src = main_img), 
                                                                                                                                            shiny::tags$h3(class = "card-title", front_title), shiny::tags$p(...), shiny::tags$button(id = paste0("btn-", 
                                                                                                                                                                                                                                                             id_front), class = "btn btn-primary btn-rotate", 
                                                                                                                                                                                                                                                 shiny::tags$i(class = "fa fa-long-arrow-right"), 
                                                                                                                                                                                                                                                 front_btn_text))), shiny::tags$div(class = paste0("card card-back-", 
                                                                                                                                                                                                                                                                                                   id, " text-center"), style = "background-color: #ffffff;", 
                                                                                                                                                                                                                                                                                    shiny::br(), shiny::tags$div(class = "card-header", 
                                                                                                                                                                                                                                                                                                                 shiny::tags$p(shiny::tags$button(id = paste0("btn-", 
                                                                                                                                                                                                                                                                                                                                                              id_back), class = "btn btn-primary btn-rotate", 
                                                                                                                                                                                                                                                                                                                                                  shiny::tags$i(class = "fa fa-long-arrow-left"), 
                                                                                                                                                                                                                                                                                                                                                  back_btn_text), shiny::h4(back_title))), shiny::hr(), 
                                                                                                                                                                                                                                                                                    shiny::tags$div(class = "card-block", shiny::tags$p(back_content)))))
  shiny::tagList(shiny::singleton(shiny::tags$head(shiny::tags$style(shiny::HTML(paste0("/* Card styles for rotation */\n              .rotate-container {\n                position: relative;\n               }\n               .rotate-container .card-front-", 
                                                                                        id, ", .rotate-container .card-back-", id, " {\n                width: 100%;\n                height: 100%;\n                -webkit-transform: perspective(600px) rotateY(0deg);\n                transform: perspective(600px) rotateY(0deg);\n                -webkit-backface-visibility: hidden;\n                backface-visibility: hidden;\n                transition: all 0.5s linear 0s;\n               }\n               .rotate-container .card-back-", 
                                                                                        id, " {\n                -webkit-transform: perspective(1600px) rotateY(180deg);\n                transform: perspective(1600px) rotateY(180deg);\n                position: absolute;\n                top: 0;\n                left: 0;\n                right: 0;\n               }\n               .rotate-container .rotate-card-front-", 
                                                                                        id, " {\n                -webkit-transform: perspective(1600px) rotateY(-180deg);\n                transform: perspective(1600px) rotateY(-180deg);\n               }\n               .rotate-container .rotate-card-back-", 
                                                                                        id, " {\n                -webkit-transform: perspective(1600px) rotateY(0deg);\n                transform: perspective(1600px) rotateY(0deg);\n               }\n               \n               /* Modified card styles */\n               .card {\n                box-shadow: 0 8px 6px -6px rgba(0, 0, 0, 0.5);\n               }\n               .card .card-header p {\n                margin: 0;\n               }\n               \n               .card .card-background-", 
                                                                                        id, " {\n                background: url('", header_img, 
                                                                                        "');\n                height: 8em;\n                background-position: center center;\n                background-size: cover;\n               }\n               .card .avatar {\n                max-width: 6em;\n                max-height: 6em;\n                margin-top: -4em;\n                margin-bottom: 1em;\n                border: 4px solid white;\n                border-radius: 50%;\n                background: radial-gradient(#e3e3e3, #329A7C, #109381);\n               }\n               .card .btn {\n                margin-bottom: 1em;\n                cursor: pointer;\n               }\n               .card .social-links li {\n                margin: 0.5em;\n               }\n               .card .social-links a {\n                font-size: 1.5em;\n               }\n               "))), 
                                                   shiny::tags$script(shiny::HTML(paste0("$(function() {\n                // For card rotation\n                $('#btn-", 
                                                                                         id_front, "').click(function(){\n                  $('.card-front-", 
                                                                                         id, "').addClass(' rotate-card-front-", id, "');\n                  $('.card-back-", 
                                                                                         id, "').addClass(' rotate-card-back-", id, "');\n                });\n                $('#btn-", 
                                                                                         id_back, "').click(function(){\n                  $('.card-front-", 
                                                                                         id, "').removeClass(' rotate-card-front-", id, "');\n                  $('.card-back-", 
                                                                                         id, "').removeClass(' rotate-card-back-", id, "');\n                });\n              });\n              "))))), 
                 flipBoxTag)
}