% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{colorDF_themes_show}
\alias{colorDF_themes_show}
\title{Demonstrate all defined themes}
\usage{
colorDF_themes_show(themes = NULL)
}
\arguments{
\item{themes}{character vector with theme names to show}
}
\description{
Demonstrate all defined themes
}
\details{
"Themes" are simply predefined styles for colorful data frames. Some are
suitable only for dark or light backgrounds, so this function is useful for
choosing what looks best on your terminal.

When a colorful data frame is created with [colorDF()] or [as.colorDF()],
the default theme is assigned to it. The default theme is defined by the
option "colorDF_theme" set using [options()] (at startup, the default theme
is "light"). 

You can also specify the theme to use when making a data frame colorful
with [colorDF()] by using the `theme=` parameter.
}
\examples{
colorDF_themes_show()
colorDF_themes_show(themes=c("wb", "bw"))
}
