% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohorttools.R
\name{estim.hazard}
\alias{estim.hazard}
\title{Estimates hazard function using Poisson model}
\usage{
estim.hazard(
  formula,
  data,
  time,
  status,
  breaks,
  knots,
  time.eval = breaks,
  alpha = 0.05,
  use.GAM = FALSE,
  print.GAM.summary = FALSE,
  ...
)
}
\arguments{
\item{formula}{formula with Surv in LHS, NOTE! only one variable in RHS}

\item{data}{data used by formula}

\item{time}{time variables}

\item{status}{status indicator Lowest value used as sensoring.
If only one unique value detected, all are assumed events}

\item{breaks}{time is splitted with these values}

\item{knots}{knots for natural splines used in estimation of hazard function}

\item{time.eval}{in which time points hazard function is evaluate.}

\item{alpha}{significance level for confidence intervals}

\item{use.GAM}{logical determining if generalized additive model (GAM) is used}

\item{print.GAM.summary}{logical determining if summary of GAM is printed}

\item{...}{parameters for glm}
}
\value{
Returns data frame with time and hazard function values with attribute 'estim.hazard.param'
containing estimation parameters (breaks and knots)
}
\description{
Estimates hazard function using Poisson model
}
\examples{
library(survival)
tmp.hz<-estim.hazard(time=lung$time,status=lung$status)
head(tmp.hz,2)
attributes(tmp.hz)$estim.hazard.param # estimation parameters
tmp.hz2<-estim.hazard(formula=Surv(time,status)~sex,data=lung)
head(tmp.hz2,2)
}
\author{
Jari Haukka \email{jari.haukka@helsinki.fi}
}
