% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-comp.R
\name{RelationshipTestSummary}
\alias{RelationshipTestSummary}
\title{Summary table on relationship comparisons}
\usage{
RelationshipTestSummary(project, units, limit.p.value = 0.05)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{units}{The units to compare}

\item{limit.p.value}{A numeric.}
}
\value{
A data frame
}
\description{
Summary table on relationship comparisons
}
\details{
This function produce a summary table based on relationship comparisons and is reactive to a limit of p.value beyoun which differences are considered as significant and are reported in the table
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

## Here 0.6 is used only for producing an output. No signif. diff. is reported.
RelationshipTestSummary(my.project, units = c("Belgium", "Québec"), 0.6)
}
