% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr.R
\name{EdgCMap}
\alias{EdgCMap}
\title{Extract all edges from a Qualitative Data Analysis project}
\usage{
EdgCMap(project, sep = ">", coder = "qcoder")
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{sep}{(==Depreciated, with RQDA project==) A character string (often a single character) that is used in RQDA in order to express the relationships between two variables. Default is "_" if codes used in RQDA are of the form : "x_y" (\emph{i.e.} relationship from x to y), but it is possible to use ">", "->", "-->" or even "--->"}

\item{coder}{A character string indicating the coding tool used for coding the QDA. The only tool supported now is 'qcoder'. Earlier version of cogmapr worked with "RQDA" project (no more maintened).}
}
\value{
A data.frame with the relationships identified in the interviews. Each relationships is linked to an agent ('name'), an edge's name ('edge') and a simplified edge's name ('edge.a') where any extra character other than "INTERGER>INTEGER" have been removed and the separator string has been replaced with "~", the varible at the origin of the relationships ('from'), the variable at the end of the relationships ('to').
}
\description{
This function opens a Qualitative Data Analysis (QDA) project and extracts edge information.
}
\details{
The coding used in the QDA have to be done using the 'cogamp-dev' branch of the qcoder package (github : 'FrdVnW/qcoder'). devtools::install_github('FrdVnW/qcoder', ref = "cogmap-dev", upgrade = 'never')
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

EdgCMap(my.project)
}
