\name{sta.paircomparison}
\alias{sta.paircomparison}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
pairwise parameter comparison for 2-species model
}
\description{
explore coexistence patch number/density for a single scenario of a pair of parameters, 
for the case of 2-species modeling
}
\usage{
sta.paircomparison(coexistence, parnum, parameters)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{coexistence}{
list of data generated by sta.coexistence() function
}
  \item{parnum}{
number of parameters you want to choose and compare pairwisely in the model, should be less than the total number of parameters
i.e.,, for two species model<=7.
}
  \item{parameters}{
a parameter sampling point vector,for example parameters=c(.2,.5,.9), indicating three sampling points in a single
parameter. The function will thus compare the coexistence patch numbers under the cases when each of the pairwise parameters (for example,
growth rate and the competition ability of a species)=0.2,0.5 and 0.9 respectively.
}
}

\references{
Chen YH (2012) coexist: an R package for performing species coexistence modeling and analysis under asymmetric dispersal and fluctuating source-sink dynamics.
http://code.google.com/p/coexist.
}
\author{
Youhua Chen <yhchen@zoology.ubc.ca>
}


\seealso{
\code{\link{sta.paircomparison}}, 
\code{\link{sta.coexistence}},
\code{\link{batch.paircomp}}
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (coexistence, parnum = parnum, parameters = parspace) 
{
    comparisonlist <- list()
    length(comparisonlist) <- parnum * (parnum - 1)/2
    varlist <- comparisonlist
    namesvector <- vector()
    length(namesvector) <- length(comparisonlist)
    count = 0
    for (p1 in 1:(parnum - 1)) {
        for (p2 in (p1 + 1):parnum) {
            conum <- matrix(0, ncol = length(parameters), nrow = length(parameters))
            varmat <- conum
            count = count + 1
            for (i in 1:length(parameters)) {
                for (j in 1:length(parameters)) {
                  temp <- coexistence[which(coexistence[, 3 + 
                    p1] == parameters[i] & coexistence[, 3 + 
                    p2] == parameters[j]), ]
                  conum[i, j] <- mean(temp[, 3])
                  varmat[i, j] <- var(temp[, 3])
                }
            }
            comparisonlist[[count]] <- conum
            namesvector[count] <- paste(colnames(coexistence)[3 + 
                p1], colnames(coexistence)[3 + p2], sep = "-")
            varlist[[count]] <- varmat
        }
    }
    names(comparisonlist) <- namesvector
    names(varlist) <- namesvector
    return(list(mean = comparisonlist, var = varlist))
  }
}
