\name{batch.paircomp}
\alias{batch.paircomp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
batch analysis to explore coexistence density for handling different model scenarios for two focused parameters,for 2-species model
}
\description{
batch version for sta.paircomparison() function
}
\usage{
batch.paircomp(coexistlist, parnum, parameters)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{coexistlist}{
list of data generated by batch.coexistence() function
}
  \item{parnum}{
number of parameters you want to choose and compare pairwisely in the model, should be less than the total number of parameters
i.e.,, for two species model<=7.
}
  \item{parameters}{
a parameter sampling point vector,for example parameters=c(.2,.5,.9), indicating three sampling points in a single
parameter. The function will thus compare the coexistence patch numbers under the cases when each of the pairwise parameters (for example,
growth rate and the competition ability of a species)=0.2,0.5 and 0.9 respectively.
}
}

\references{
Chen YH (2012) coexist: an R package for performing species coexistence modeling and analysis under asymmetric dispersal and fluctuating source-sink dynamics.
http://code.google.com/p/coexist.
}
\author{
Youhua Chen <yhchen@zoology.ubc.ca>
}

\seealso{
\code{\link{batch.coexistence}}, 
\code{\link{sta.paircomparison}} 
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (coexistlist, parnum = parnum, parameters = parspace) 
{
    scenarionum <- length(coexistlist)
    pairlist <- list()
    length(pairlist) <- scenarionum
    for (i in 1:scenarionum) {
        pairlist[[i]] <- sta.paircomparison(coexistlist[[i]], 
            parnum = parnum, parameters = parameters)
    }
    return(pairlist)
  }
}

