% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefa_summary.R
\name{coefa_summary}
\alias{coefa_summary}
\title{Summary}
\usage{
coefa_summary(object,fa,omitWarning=FALSE)
}
\arguments{
\item{object}{A matrix of aggregated co-occurrence matrix.}

\item{fa}{The method of extract factor for aggregated co-occurrence matrix.
Principal components (fa="pc"),principal axis factor analysis (fa="fa),or both
of them could be choose.}

\item{omitWarning}{The default is not to omit warning.If omitWarning is default,
suggestions(Scree plot and Kaiser's criterion, parallel analysis) for
subsequent factor analysis will not be provided when the matrix is not
positive definite.If omitWarning=TRUE,warning will be skipped and suggestions
will be forced.}
}
\value{
A list containing the matrix cases produced by each process of coefa.
}
\description{
The function coefa_summary provides a preliminary preparation and suggestion
for the later factor analysis using the aggregated co-occurrence matrix.
And the results, the scree plot and Kaiser's criterion will be plotted by
this function.
}
\details{
It should be noted that we should be alert to the positive
definiteness of the aggregated matrix. If the matrix is non-positive
definite, we should choose the factor extraction method carefully or we
should take other solutions (remove questions appropriately, or smooth
the matrix).
}
\examples{
#summary
coefa_summary(matrices_acm,fa="fa")
}
\references{
Cao,Y., & Zhang, Y. (2017). Multivariate statistic methods in psychology and
education. Beijing: Peking university press.158.
}
