% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_fun.R
\name{index_fun}
\alias{index_fun}
\alias{index}
\alias{index.data.frame}
\alias{index.matrix}
\title{Calculate index based on classification scheme}
\usage{
index(classified, ...)

\method{index}{data.frame}(classified, ...)

\method{index}{matrix}(classified, index = NULL, cc = NULL, ...)
}
\arguments{
\item{classified}{output from \code{\link[=classify]{classify()}}}

\item{...}{used internally}

\item{index}{name of column with 'weights' from corresponding
\code{\link{classcodes}} object. Can be \code{NULL} if the index is just a unweighted
count of all identified groups.}

\item{cc}{\code{\link{classcodes}} object. Can be \code{NULL} if a \code{classcodes} object is
already available as an attribute of \code{classified} (which is often the case)
and/or if \code{index = NULL}.}
}
\value{
Named numeric index vector with names corresponding to
\code{rownames(classified)}
}
\description{
This is the third step of \code{codify() \%>\% classify() \%>\% index()}.
The function takes classified case data and calculates
(weighted) index sums as specified by weights from a \code{classcodes} object.
}
\details{
Index weights for subordinate hierarchical classes
(as identified by \code{attr(cc, "hierarchy")}) are excluded in presence of
superior classes if index specified with argument \code{index}.
}
\examples{

# Prepare some codified data with ICD-10 codes during 1 year (365 days)
# before surgery
x <-
  codify(
    ex_people,
    ex_icd10,
    id        = "name",
    code      = "icd10",
    date      = "surgery",
    days      = c(-365, 0),
    code_date = "admission"
  )

# Classify those patients by the Charlson comorbidity indices
cl <- classify(x, "charlson")

# Calculate (weighted) index values
head(index(cl))                  # Un-weighted sum/no of conditions for each patient
head(index(cl, "quan_original")) # Weighted index (Quan et al. 2005; see `?charlson`)
head(index(cl, "quan_updated"))  # Weighted index (Quan et al. 2011; see `?charlson`)

# Tabulate index for all patients.
# As expected, most patients are healthy and have index = 0/NA,
# where NA indicates no recorded hospital visits
# found in `ex_icd10` during codification.
# In practice, those patients might be assumed to have 0 comorbidity as well.
table(index(cl, "quan_original"), useNA = "always")

# If `cl` is a matrix without additional attributes (as imposed by `codify()`)
# an explicit classcodes object must be specified by the `cc` argument
cl2 <- as.matrix(cl)
head(index(cl2, cc = "charlson"))
}
\seealso{
Other verbs: 
\code{\link{categorize}()},
\code{\link{classify}()},
\code{\link{codify}()}
}
\concept{verbs}
