% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{cocoOptim}
\alias{cocoOptim}
\title{Optimizer for coco objects}
\usage{
cocoOptim(coco.object, boundaries = list(), ncores = "auto", safe = TRUE,
optim.type, optim.control)
}
\arguments{
\item{coco.object}{(\code{S4}) A \link{coco} object.}

\item{boundaries}{(\code{list}) If provided, a list containing lower, initial, and upper values for the parameters, as defined by \link{getBoundaries}. If not provided, these values are automatically computed with global lower and upper bounds set to -2 and 2.}

\item{ncores}{(\code{character} or \code{integer}) The number of threads to use for the optimization. If set to \code{"auto"}, the number of threads is chosen based on system capabilities or a fraction of the available cores.}

\item{safe}{(\code{logical}) If \code{TRUE}, the function avoids Cholesky decomposition errors due to ill-posed covariance matrices by returning a pre-defined large value. Defaults to \code{TRUE}.
\itemize{
\item \code{"ml"}: Classical Maximum Likelihood estimation.
\item \code{"pml"}: Profile Maximum Likelihood, factoring out the spatial trend for dense objects or the global marginal variance parameter for sparse objects.
}}

\item{optim.type}{(\code{character}) The optimization approach. Options include:}

\item{optim.control}{(\code{list}) A list of settings to be passed to the \link[optimParallel]{optimParallel} function [2].}
}
\value{
(\code{S4}) An optimized S4 object of class \code{coco}.
}
\description{
Estimation the spatial model parameters using the L-BFGS-B optimizer [1].
}
\examples{
\dontrun{
model.list <- list('mean' = 0,
                   'std.dev' = formula( ~ 1 + cov_x + cov_y),
                   'scale' = formula( ~ 1 + cov_x + cov_y),
                   'aniso' = 0,
                   'tilt' = 0,
                   'smooth' = 3/2,
                   'nugget' = -Inf)
                   
coco_object <- coco(type = 'dense',
                    data = holes[[1]][1:100,],
                    locs = as.matrix(holes[[1]][1:100,1:2]),
                    z = holes[[1]][1:100,]$z,
                    model.list = model.list)
                    
optim_coco <- cocoOptim(coco_object,
boundaries = getBoundaries(coco_object,
lower.value = -3, 3))

plotOptimInfo(optim_coco)

plot(optim_coco)

plot(optim_coco, type = 'ellipse')

plot(optim_coco, type = 'correlations', index = c(2,3,5))

summary(optim_coco)
 
getEstims(optim_coco)

}

}
\references{
[1] Byrd, Richard H., et al. \emph{"A limited memory algorithm for bound constrained optimization."}
SIAM Journal on scientific computing 16.5 (1995): 1190-1208.

[2] Gerber, Florian, and Reinhard Furrer. \emph{"optimParallel: An R package providing a parallel version of the L-BFGS-B optimization method."}
R Journal 11.1 (2019): 352-358.
}
\seealso{
[\link[optimParallel]{optimParallel}]
}
\author{
Federico Blasi
}
