% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand-moc.R
\name{expandMOC}
\alias{expandMOC}
\title{Expand matrix of clusters}
\usage{
expandMOC(clLabels, datasetNames = NULL)
}
\arguments{
\item{clLabels}{Matrix of cluster labels of size N x M.}

\item{datasetNames}{Vector of cluster names of length M. Default is NULL.}
}
\value{
The output is a list containing:
\item{moc}{the matrix of clusters.}
\item{datasetIndicator}{a vector containing the dataset indicator.}
\item{datasetNames}{an expanded vector of dataset names for the moc.}
}
\description{
Expand matrix of cluster labels into matrix of clusters
}
\examples{
# Load data
data <- list()
data[[1]] <- as.matrix(read.csv(system.file("extdata", "dataset1.csv",
package = "coca"), row.names = 1))
data[[2]] <- as.matrix(read.csv(system.file("extdata", "dataset2.csv",
package = "coca"), row.names = 1))
data[[3]] <- as.matrix(read.csv(system.file("extdata", "dataset3.csv",
package = "coca"), row.names = 1))

# Build matrix of clusters
outputBuildMOC <- buildMOC(data, M = 3, K = 6, distances = "cor")

# Extract matrix of clusters
clLabels <- outputBuildMOC$clLabels

# Impute missing values
outputFillMOC <- fillMOC(clLabels, data = data)

# Replace matrix of cluster labels with new (full) one
clLabels <- outputFillMOC$fullClLabels

# Expand matrix of cluster labels into matrix of clusters
outputExpandMOC <- expandMOC(clLabels)
clLabels <- outputExpandMOC$clLabels
}
\author{
Alessandra Cabassi \email{alessandra.cabassi@mrc-bsu.cam.ac.uk}
}
