% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{compute_log_f_gradient_rcpp}
\alias{compute_log_f_gradient_rcpp}
\title{Compute the Gradient of the Log-Likelihood Function Generalized odds rate (GOR)}
\arguments{
\item{Params}{A numeric vector of parameters.}
}
\value{
A numeric vector representing the gradient of the log-likelihood.
}
\description{
This function computes the gradient of the log-likelihood function for the parametric model (GOR Approach).
}
\examples{
library(cmpp)
features <- matrix(rnorm(300, 1, 2), nrow = 100, ncol = 3)
set.seed(1984)
delta1 <- sample(c(0, 1), 100, replace = TRUE)
delta2 <- 1 - delta1
x <- rexp(100, rate = 1/3)
Initialize(features, x, delta1, delta2, h = 1e-5)
params <- rep(0.001, 2 * (ncol(features) + 3))
gradient <- compute_log_f_gradient_rcpp(params)
print(gradient)

}
