% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findiff.R
\name{findiff}
\alias{findiff}
\alias{symdiff}
\alias{findiff2}
\alias{rdiff}
\title{Finite Differences}
\usage{
findiff(f, x, h = x * sqrt(.Machine$double.eps))

symdiff(f, x, h = x * .Machine$double.eps^(1/3))

findiff2(f, x, h)

rdiff(f, x, n = 10, h = 1e-04)
}
\arguments{
\item{f}{function to differentiate}

\item{x}{the \code{x}-value to differentiate at}

\item{h}{the step-size for evaluation}

\item{n}{the maximum number of convergence steps in \code{rdiff}}
}
\value{
the value of the derivative
}
\description{
Finite differences formulas
}
\details{
The \code{findiff} formula uses the finite differences formula to
find the derivative of \code{f} at \code{x}.  The value of \code{h}
is the step size of the evaluation. The function \code{findiff2}
provides the second derivative.
}
\examples{
findiff(sin, pi, 1e-3)
symdiff(sin, pi, 1e-3)

}
\concept{differentiation}
