% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.conceptMap.R
\name{plot.conceptMap}
\alias{plot.conceptMap}
\title{Plot a Concept Map}
\usage{
\method{plot}{conceptMap}(x, whichPlot = "all", ...)
}
\arguments{
\item{x}{An object of class \code{conceptMap}. This object must contain
plotting data and attributes specific to the method used for creating the concept map.}

\item{whichPlot}{A character string specifying which plot to display. Options depend on the
method used to create the concept map:
\describe{
\item{\code{"all"}}{Displays all available plots for the given method.}
\item{\code{"heatmap"}}{Displays the heatmap plot (if available).}
\item{\code{"silhouette"}}{Displays the silhouette plot (if available).}
\item{\code{"network"}}{Displays the network plot (if available).}
\item{\code{"cmds"}}{Displays the CMDs plot (if available).}
}
The default is \code{"all"}.}

\item{...}{arguments to be passed to methods}
}
\value{
This function displays the specified plot(s) in the current graphical device.
}
\description{
This function generates visualizations for an object of class \code{conceptMap}.
Depending on the method used to create the concept map, different types of plots
(e.g., heatmap, silhouette, network, or CMDS plots) are available.
}
\details{
The function behaves differently depending on the method used to create
the concept map. The \code{conceptMap} object must include attributes such as
\code{method} (e.g., "kmeans", "network", or "cmds") and the corresponding plot
objects (e.g., \code{heatmapPlot}, \code{silhouettePlot}, etc.).

The following methods are supported:
\itemize{
\item \code{"kmeans"}: Supports \code{"heatmap"} and \code{"silhouette"} plots.
\item \code{"network"}: Supports \code{"heatmap"} and \code{"network"} plots.
\item \code{"cmds"}: Supports \code{"heatmap"}, \code{"silhouette"}, and \code{"cmds"} plots.
}
}
\examples{
# Simulate data with custom parameters:
set.seed(1)
myCMData <- simulateCardData(nSorters=40, pCorrect=.90, attributeWeights=c(1,1,1,1))

# Subject the data to sorter cluster analysis
myCMDataBySorters <- sorterMapping(myCMData)

# Subject sorter cluster 3 to concept mapping using default "network" method
myCMAnalysis3 <- conceptMapping(myCMDataBySorters[[3]])

# Visualise the concept map
plot(myCMAnalysis3)

}
