% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{calc_sc3_stability_cluster}
\alias{calc_sc3_stability_cluster}
\title{Calculate single SC3 stability}
\usage{
calc_sc3_stability_cluster(clusterings, res, cluster)
}
\arguments{
\item{clusterings}{numeric matrix containing clustering information, each
column contains clustering at a separate resolution}

\item{res}{resolution of the cluster to calculate stability for}

\item{cluster}{index of the cluster to calculate stability for}
}
\value{
SC3 stability index
}
\description{
Calculate the SC3 stability index for a single cluster in a set of
clusterings. The index varies from 0 to 1, where 1 suggests that a cluster is
more stable across resolutions.
}
\details{
This index was originally introduced in the \code{SC3} package for clustering
single-cell RNA-seq data. Clusters are awarded increased stability if they
share the same samples as a cluster at another resolution and penalised at
higher resolutions. We use a slightly different notation to describe the
score but the results are the same:

\deqn{
  s(c_{k, i}) =
  \frac{1}{size(L) + 1}
  \sum_{l \in L}
    \sum_{j \in N_l}
      \frac{size(c_{k, i} \cap c_{l, j})}{size(c_{l, j}) * size(N_l) ^ 2}
}{
  s(c_{k, i}) = (1 / (size(L) + 1)) * (sum_{l in L} sum_{j in N_l}
  (size(intersect(c_{k, i}, c_{l, j}))) / (size(c_{l, j}) * size(N_l) ^ 2))
}

Where:
\itemize{
\item \verb{c_\{x, y\}} is cluster \code{y} at resolution \code{x}
\item \code{k} is the resolution of the cluster we want to score
\item \code{i} is the index of the cluster we want to score
\item \code{L} is the set of all resolutions except \code{k}
\item \code{l} is a resolution in \code{L}
\item \code{N_l} is the set of clusters at resolution \code{l} that share samples with
\verb{c_\{k, i\}}
\item \code{j} is a cluster in \code{N_l}
}
}
\seealso{
The documentation for the \code{calculate_stability} function in the
SC3 package
}
