% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustree_overlay.R
\name{clustree_overlay}
\alias{clustree_overlay}
\alias{clustree_overlay.matrix}
\alias{clustree_overlay.data.frame}
\alias{clustree_overlay.SingleCellExperiment}
\alias{clustree_overlay.seurat}
\title{Overlay a clustering tree}
\usage{
clustree_overlay(x, ...)

\method{clustree_overlay}{matrix}(x, prefix, metadata, x_value, y_value,
  suffix = NULL, count_filter = 0, prop_filter = 0.1,
  node_colour = prefix, node_colour_aggr = NULL, node_size = "size",
  node_size_aggr = NULL, node_size_range = c(4, 15), node_alpha = 1,
  node_alpha_aggr = NULL, edge_width = 1, use_colour = c("edges",
  "points"), alt_colour = "black", point_size = 3, point_alpha = 0.2,
  point_shape = 18, label_nodes = FALSE, label_size = 3,
  plot_sides = FALSE, side_point_jitter = 0.45,
  side_point_offset = 1, ...)

\method{clustree_overlay}{data.frame}(x, prefix, ...)

\method{clustree_overlay}{SingleCellExperiment}(x, prefix, x_value,
  y_value, exprs = "counts", red_dim = NULL, ...)

\method{clustree_overlay}{seurat}(x, x_value, y_value, prefix = "res.",
  exprs = c("data", "raw.data", "scale.data"), red_dim = NULL, ...)
}
\arguments{
\item{x}{object containing clustering data}

\item{...}{extra parameters passed to other methods}

\item{prefix}{string indicating columns containing clustering information}

\item{metadata}{data.frame containing metadata on each sample that can be
used as node aesthetics}

\item{x_value}{numeric metadata column to use as the x axis}

\item{y_value}{numeric metadata column to use as the y axis}

\item{suffix}{string at the end of column names containing clustering
information}

\item{count_filter}{count threshold for filtering edges in the clustering
graph}

\item{prop_filter}{in proportion threshold for filtering edges in the
clustering graph}

\item{node_colour}{either a value indicating a colour to use for all nodes or
the name of a metadata column to colour nodes by}

\item{node_colour_aggr}{if \code{node_colour} is a column name than a string
giving the name of a function to aggregate that column for samples in each
cluster}

\item{node_size}{either a numeric value giving the size of all nodes or the
name of a metadata column to use for node sizes}

\item{node_size_aggr}{if \code{node_size} is a column name than a string
giving the name of a function to aggregate that column for samples in each
cluster}

\item{node_size_range}{numeric vector of length two giving the maximum and
minimum point size for plotting nodes}

\item{node_alpha}{either a numeric value giving the alpha of all nodes or the
name of a metadata column to use for node transparency}

\item{node_alpha_aggr}{if \code{node_aggr} is a column name than a string
giving the name of a function to aggregate that column for samples in each
cluster}

\item{edge_width}{numeric value giving the width of plotted edges}

\item{use_colour}{one of "edges" or "points" specifying which element to
apply the colour aesthetic to}

\item{alt_colour}{colour value to be used for edges or points (whichever is
NOT given by \code{use_colour})}

\item{point_size}{numeric value giving the size of sample points}

\item{point_alpha}{numeric value giving the alpha of sample points}

\item{point_shape}{numeric value giving the shape of sample points}

\item{label_nodes}{logical value indicating whether to add labels to
clustering graph nodes}

\item{label_size}{numeric value giving the size of node labels is
\code{label_nodes} is \code{TRUE}}

\item{plot_sides}{logical value indicating whether to produce side on plots}

\item{side_point_jitter}{numeric value giving the y-direction spread of
points in side plots}

\item{side_point_offset}{numeric value giving the y-direction offset for
points in side plots}

\item{exprs}{source of gene expression information to use as node aesthetics,
for \code{SingleCellExperiment} objects it must be a name in \code{assayNames(x)}, for
a \code{seurat} object it must be one of \code{data}, \code{raw.data} or \code{scale.data}}

\item{red_dim}{dimensionality reduction to use as a source for x_value and
y_value}
}
\value{
a \code{ggplot} object if \code{plot_sides} is \code{FALSE} or a list of \code{ggplot}
objects if \code{plot_sides} is \code{TRUE}
}
\description{
Creates a plot of a clustering tree overlaid on a scatter plot of individual
samples.
}
\details{
\strong{Data sources}

Plotting a clustering tree requires information about which cluster each
sample has been assigned to at different resolutions. This information can
be supplied in various forms, as a matrix, data.frame or more specialised
object. In all cases the object provided must contain numeric columns with
the naming structure \code{PXS} where \code{P} is a prefix indicating that the column
contains clustering information, \code{X} is a numeric value indicating the
clustering resolution and \code{S} is any additional suffix to be removed. For
\code{SingleCellExperiment} objects this information must be in the \code{colData} slot
and for \code{Seurat} objects it must be in the \code{meta.data} slot. For all objects
except matrices any additional columns can be used as aesthetics.

\strong{Filtering}

Edges in the graph can be filtered by adjusting the \code{count_filter} and
\code{prop_filter} parameters. The \code{count_filter} removes any edges that represent
less than that number of samples, while the \code{prop_filter} removes edges that
represent less than that proportion of cells in the node it points towards.

\strong{Node aesthetics}

The aesthetics of the plotted nodes can be controlled in various ways. By
default the colour indicates the clustering resolution, the size indicates
the number of samples in that cluster and the transparency is set to 100%.
Each of these can be set to a specific value or linked to a supplied metadata
column. For a \code{SingleCellExperiment} or \code{Seurat} object the names of genes
can also be used. If a metadata column is used than an aggregation function
must also be supplied to combine the samples in each cluster. This function
must take a vector of values and return a single value.

\strong{Colour aesthetic}

The colour aesthetic can be applied to either edges or sample points by
setting \code{use_colour}. If "edges" is selected edges will be coloured according
to the clustering resolution they originate at. If "points" is selected they
will be coloured according to the cluster they are assigned to at the highest
resolution.

\strong{Dimensionality reductions}

For \code{SingleCellExperiment} and \code{Seurat} objects precomputed dimensionality
reductions can be used for x or y aesthetics. To do so \code{red_dim} must be set
to the name of a dimensionality reduction in \code{reducedDimNames(x)} (for a
\code{SingleCellExperiment}) or \code{x@dr} (for a \code{Seurat} object). \code{x_value} and
\code{y_value} can then be set to \code{red_dimX} when \code{red_dim} matches the \code{red_dim}
argument and \code{X} is the column of the dimensionality reduction to use.
}
\examples{
data(iris_clusts)
clustree_overlay(iris_clusts, prefix = "K", x_value = "PC1", y_value = "PC2")

}
