% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa.did.normal.R
\name{cpa.did.normal}
\alias{cpa.did.normal}
\title{Power calculations for difference-in-difference cluster randomized trials, continuous outcome}
\usage{
cpa.did.normal(
  alpha = 0.05,
  power = 0.8,
  nclusters = NA,
  nsubjects = NA,
  d = NA,
  ICC = NA,
  rho_c = NA,
  rho_s = NA,
  vart = NA,
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error.}

\item{nclusters}{The number of clusters per condition. It must be greater than 1.}

\item{nsubjects}{The mean of the cluster sizes, or a vector of cluster sizes for one arm.}

\item{d}{The difference in mean change between conditions (i.e. "difference-in-difference").}

\item{ICC}{The intraclass correlation.}

\item{rho_c}{The correlation between baseline and post-test outcomes at the
cluster level. This value can be used in both cross-sectional and cohort
designs. If this quantity is unknown, a value of 0 is a conservative estimate.}

\item{rho_s}{The correlation between baseline and post-test outcomes at the
subject level. This should be used for a cohort design or a mixture of cohort
and cross-sectional designs. In a purely cross-sectional design (baseline subjects
are completely different from post-test subjects), this value should be 0.}

\item{vart}{The total variation of the outcome (the sum of within- and between-cluster variation).}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed argument.
}
\description{
Compute the power of a difference-in-difference cluster randomized trial design with a continuous outcome,
or determine parameters to obtain a target power.
}
\details{
Exactly one of \code{alpha}, \code{power}, \code{nclusters}, \code{nsubjects},
  \code{d}, \code{ICC}, \code{rho_c}, \code{rho_s}, and \code{vart}
  must be passed as \code{NA}. Note that \code{alpha} and\code{power}
  have non-\code{NA} defaults, so if those are the parameters of 
  interest they must be explicitly passed as \code{NA}.
  
If \code{nsubjects} is a vector the values, \code{nclusters} will be recalculated
   using the values in \code{nsubjects}.
}
\section{Note}{

  This function was inspired by work from Stephane Champely (pwr.t.test) and
  Peter Dalgaard (power.t.test). As with those functions, 'uniroot' is used to
  solve power equation for unknowns, so you may see
  errors from it, notably about inability to bracket the root when
  invalid arguments are given.
}

\section{Authors}{

Jonathan Moyer (\email{jon.moyer@gmail.com}), Ken Kleinman (\email{ken.kleinman@gmail.com})
}

\examples{
# Find the number of clusters per condition needed for a trial with alpha = 0.05, 
# power = 0.80, nsubjects = 100, d = 0.50 units, ICC = 0.05, rho_c = 0.50, rho_s = 0.70,
# and vart = 1 unit.
cpa.did.normal(nsubjects = 100 , d = 0.5, ICC = 0.05, rho_c = 0.50, rho_s = 0.70, vart = 1)
# 
# The result, nclusters = 4.683358, suggests 5 clusters per condition should be used.

}
\references{
Rutterford C, Copas A, Eldridge S. (2015) Methods for sample size
  determination in cluster randomized trials. Int J Epidemiol. 44(3):1051-1067.

Teerenstra S, Eldridge S, Graff M, de Hoop E, Borm, GF. (2012) A simple
  sample size formula for analysis of covariance in cluster randomized trials.
  Statist Med. 31:2169-2178
}
