% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterpath_weights.R
\name{clusterpath_weights}
\alias{clusterpath_weights}
\title{Compute the Weight Matrix for the Clusterpath Penalty}
\usage{
clusterpath_weights(S, phi, k, connected = TRUE)
}
\arguments{
\item{S}{The sample covariance matrix of the data.}

\item{phi}{Tuning parameter of the weights.}

\item{k}{The number of nearest neighbors that should be used to set weights
to a nonzero value. If \code{0 < k < ncol(S)}, the dense weight matrix will
be made sparse, otherwise the dense matrix is returned.}

\item{connected}{A logical indicating whether a connected weight matrix
should be enforced. Defaults to \code{TRUE}.}
}
\value{
A weight matrix for the clusterpath penalty.
}
\description{
Compute the (possibly sparse) weight matrix for the clusterpath penalty in
the clusterpath estimator of the Gaussian graphical model (CGGM). Weights
are computed based on a distance measure so that variables that are close
are clustered more quickly (higher weight) than variables that are far apart
(lower weight). Only neighboring variables thereby receive a nonzero weight.
Additionally, groups of variables that would not be connected via nonzero
weights due to the sparsity of the weight matrix can still be connected by
applying a minimum spanning tree algorithm.
}
\examples{
# Generate data
set.seed(3)
Theta <- matrix(
  c(2, 1, 0, 0,
    1, 2, 0, 0,
    0, 0, 4, 1,
    0, 0, 1, 4),
  nrow = 4
)
X <- mvtnorm::rmvnorm(n = 100, sigma = solve(Theta))

# Estimate the covariance matrix
S <- cov(X)

# Compute the weight matrix for the clusterpath (clustering) weights
W_cpath <- clusterpath_weights(S, phi = 1, k = 2)
W_cpath
}
\references{
D.J.W. Touw, A. Alfons, P.J.F. Groenen and I. Wilms (2025)
\emph{Clusterpath Gaussian Graphical Modeling}. arXiv:2407.00644.
doi:10.48550/arXiv.2407.00644.
}
\seealso{
\code{\link{lasso_weights}()}, \code{\link{cggm}()},
\code{\link{cggm_refit}()}, \code{\link{cggm_cv}()}
}
\author{
Daniel J.W. Touw
}
