\name{mergematrix-class}
\docType{class}
\alias{mergematrix-class}
\alias{mergematrix}

\title{Class "mergematrix"}
\description{
Objects of class \code{'mergematrix'} hold the merge matrix  in the same way that a consmatrix object holds a consensus matrix. As merge matrices only
make sense in the context of the consensus clustering results that were used to generate them we do not store the meta-data for any one consensus clustering parameter set
as we do for a 'consmatrix' object. All we need to identify the 'mergematrix' is the cluster number.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("mergematrix", ...)}, although they are normally generated by the \code{\link{cluscomp}} function when merge is specfied. 
}
\section{Slots}{
  \describe{
    \item{\code{cm}:}{Object of class \code{"matrix"} - the merge matrix itself}
    \item{\code{k}:}{Object of class \code{"numeric"}  - the cluster number (k) value for which the merge was calculated}
    \item{\code{a}:}{Object of class \code{"character"} - always takes the value of 'merge' to identify it as a merge matrix}
  }
}

\references{
Merged consensus clustering to assess and improve classification of microarray data. Simpson, T.I., Armstrong, J.D. and Jarman A.P.
(submitted).}

\author{
Dr. T. Ian Simpson
\email{ian.simpson@ed.ac.uk}
}

\seealso{
Also see the \code{\link{cluscomp}} function.
}
\examples{
showClass("mergematrix")

#load the cmr
data(testcmr);

#get a merge matrix object
mm <- testcmr$merge_k4;

#plot a heatmap of the merge matrix
heatmap(mm@cm);
}
\keyword{classes}